@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.GetApiSchemaPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property apiId API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property schemaId Schema id identifier. Must be unique in the current API Management service instance.
 * @property serviceName The name of the API Management service.
 */
public data class GetApiSchemaPlainArgs(
    public val apiId: String,
    public val resourceGroupName: String,
    public val schemaId: String,
    public val serviceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.GetApiSchemaPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.GetApiSchemaPlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.GetApiSchemaPlainArgs.builder()
            .apiId(apiId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .schemaId(schemaId.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApiSchemaPlainArgs].
 */
@PulumiTagMarker
public class GetApiSchemaPlainArgsBuilder internal constructor() {
    private var apiId: String? = null

    private var resourceGroupName: String? = null

    private var schemaId: String? = null

    private var serviceName: String? = null

    /**
     * @param value API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
     */
    @JvmName("ylhvphbgxxbwnfyu")
    public suspend fun apiId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.apiId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mhaevmsrwbnhwufw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Schema id identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("yimfvgqbvwsvqsjv")
    public suspend fun schemaId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.schemaId = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("ievmhktxjqioknce")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetApiSchemaPlainArgs = GetApiSchemaPlainArgs(
        apiId = apiId ?: throw PulumiNullFieldException("apiId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        schemaId = schemaId ?: throw PulumiNullFieldException("schemaId"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
