@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.GetAuthorizationAccessPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property authorizationAccessPolicyId Identifier of the authorization access policy.
 * @property authorizationId Identifier of the authorization.
 * @property authorizationProviderId Identifier of the authorization provider.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 */
public data class GetAuthorizationAccessPolicyPlainArgs(
    public val authorizationAccessPolicyId: String,
    public val authorizationId: String,
    public val authorizationProviderId: String,
    public val resourceGroupName: String,
    public val serviceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.GetAuthorizationAccessPolicyPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.apimanagement.inputs.GetAuthorizationAccessPolicyPlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.GetAuthorizationAccessPolicyPlainArgs.builder()
            .authorizationAccessPolicyId(authorizationAccessPolicyId.let({ args0 -> args0 }))
            .authorizationId(authorizationId.let({ args0 -> args0 }))
            .authorizationProviderId(authorizationProviderId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAuthorizationAccessPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetAuthorizationAccessPolicyPlainArgsBuilder internal constructor() {
    private var authorizationAccessPolicyId: String? = null

    private var authorizationId: String? = null

    private var authorizationProviderId: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    /**
     * @param value Identifier of the authorization access policy.
     */
    @JvmName("lvfogvxhnfsxfdbg")
    public suspend fun authorizationAccessPolicyId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.authorizationAccessPolicyId = mapped
    }

    /**
     * @param value Identifier of the authorization.
     */
    @JvmName("oukfvfiyfowvodoa")
    public suspend fun authorizationId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.authorizationId = mapped
    }

    /**
     * @param value Identifier of the authorization provider.
     */
    @JvmName("oqxebwsdshesusal")
    public suspend fun authorizationProviderId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.authorizationProviderId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("focnelnqatlmxrus")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("aapfgnoatomfujbn")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetAuthorizationAccessPolicyPlainArgs =
        GetAuthorizationAccessPolicyPlainArgs(
            authorizationAccessPolicyId = authorizationAccessPolicyId ?: throw
                PulumiNullFieldException("authorizationAccessPolicyId"),
            authorizationId = authorizationId ?: throw PulumiNullFieldException("authorizationId"),
            authorizationProviderId = authorizationProviderId ?: throw
                PulumiNullFieldException("authorizationProviderId"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
        )
}
