@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.GetCertificatePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property certificateId Identifier of the certificate entity. Must be unique in the current API Management service instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 */
public data class GetCertificatePlainArgs(
    public val certificateId: String,
    public val resourceGroupName: String,
    public val serviceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.GetCertificatePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.GetCertificatePlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.GetCertificatePlainArgs.builder()
            .certificateId(certificateId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCertificatePlainArgs].
 */
@PulumiTagMarker
public class GetCertificatePlainArgsBuilder internal constructor() {
    private var certificateId: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    /**
     * @param value Identifier of the certificate entity. Must be unique in the current API Management service instance.
     */
    @JvmName("citfsttrroiqjepa")
    public suspend fun certificateId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.certificateId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pxvjvjgihyplexum")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("suhvqfmvrseipqwr")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetCertificatePlainArgs = GetCertificatePlainArgs(
        certificateId = certificateId ?: throw PulumiNullFieldException("certificateId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
