@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.GetUserSharedAccessTokenPlainArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.enums.KeyType
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expiry The Expiry time of the Token. Maximum token expiry time is set to 30 days. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
 * @property keyType The Key to be used to generate token for user.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property userId User identifier. Must be unique in the current API Management service instance.
 */
public data class GetUserSharedAccessTokenPlainArgs(
    public val expiry: String,
    public val keyType: KeyType,
    public val resourceGroupName: String,
    public val serviceName: String,
    public val userId: String,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.GetUserSharedAccessTokenPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.apimanagement.inputs.GetUserSharedAccessTokenPlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.GetUserSharedAccessTokenPlainArgs.builder()
            .expiry(expiry.let({ args0 -> args0 }))
            .keyType(keyType.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 }))
            .userId(userId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetUserSharedAccessTokenPlainArgs].
 */
@PulumiTagMarker
public class GetUserSharedAccessTokenPlainArgsBuilder internal constructor() {
    private var expiry: String? = null

    private var keyType: KeyType? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    private var userId: String? = null

    /**
     * @param value The Expiry time of the Token. Maximum token expiry time is set to 30 days. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     */
    @JvmName("gynmiunsbbdxjyln")
    public suspend fun expiry(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.expiry = mapped
    }

    /**
     * @param value The Key to be used to generate token for user.
     */
    @JvmName("makffwhoxrvrvckj")
    public suspend fun keyType(`value`: KeyType) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.keyType = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yybbuvjgwflrvsgc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("cjjkgspetwrklgos")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    /**
     * @param value User identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("iiwpuwlhhapxqstw")
    public suspend fun userId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.userId = mapped
    }

    internal fun build(): GetUserSharedAccessTokenPlainArgs = GetUserSharedAccessTokenPlainArgs(
        expiry = expiry ?: throw PulumiNullFieldException("expiry"),
        keyType = keyType ?: throw PulumiNullFieldException("keyType"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
        userId = userId ?: throw PulumiNullFieldException("userId"),
    )
}
