@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.GetWorkspaceApiSchemaPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property apiId API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property schemaId Schema id identifier. Must be unique in the current API Management service instance.
 * @property serviceName The name of the API Management service.
 * @property workspaceId Workspace identifier. Must be unique in the current API Management service instance.
 */
public data class GetWorkspaceApiSchemaPlainArgs(
    public val apiId: String,
    public val resourceGroupName: String,
    public val schemaId: String,
    public val serviceName: String,
    public val workspaceId: String,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.GetWorkspaceApiSchemaPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.GetWorkspaceApiSchemaPlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.GetWorkspaceApiSchemaPlainArgs.builder()
            .apiId(apiId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .schemaId(schemaId.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 }))
            .workspaceId(workspaceId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWorkspaceApiSchemaPlainArgs].
 */
@PulumiTagMarker
public class GetWorkspaceApiSchemaPlainArgsBuilder internal constructor() {
    private var apiId: String? = null

    private var resourceGroupName: String? = null

    private var schemaId: String? = null

    private var serviceName: String? = null

    private var workspaceId: String? = null

    /**
     * @param value API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
     */
    @JvmName("evcumeqcfpimwgii")
    public suspend fun apiId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.apiId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rtogidvltkcpvvuv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Schema id identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("abahbmkkuabjqaak")
    public suspend fun schemaId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.schemaId = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("xcmxoowqeesyevfw")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    /**
     * @param value Workspace identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("tofewtcbhfuxawpd")
    public suspend fun workspaceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceId = mapped
    }

    internal fun build(): GetWorkspaceApiSchemaPlainArgs = GetWorkspaceApiSchemaPlainArgs(
        apiId = apiId ?: throw PulumiNullFieldException("apiId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        schemaId = schemaId ?: throw PulumiNullFieldException("schemaId"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
        workspaceId = workspaceId ?: throw PulumiNullFieldException("workspaceId"),
    )
}
