@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.HttpMessageDiagnosticArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Http message diagnostic settings.
 * @property body Body logging settings.
 * @property dataMasking Data masking settings.
 * @property headers Array of HTTP Headers to log.
 */
public data class HttpMessageDiagnosticArgs(
    public val body: Output<BodyDiagnosticSettingsArgs>? = null,
    public val dataMasking: Output<DataMaskingArgs>? = null,
    public val headers: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.HttpMessageDiagnosticArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.HttpMessageDiagnosticArgs =
        com.pulumi.azurenative.apimanagement.inputs.HttpMessageDiagnosticArgs.builder()
            .body(body?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dataMasking(dataMasking?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .headers(headers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [HttpMessageDiagnosticArgs].
 */
@PulumiTagMarker
public class HttpMessageDiagnosticArgsBuilder internal constructor() {
    private var body: Output<BodyDiagnosticSettingsArgs>? = null

    private var dataMasking: Output<DataMaskingArgs>? = null

    private var headers: Output<List<String>>? = null

    /**
     * @param value Body logging settings.
     */
    @JvmName("tvwmtjueqolbcaka")
    public suspend fun body(`value`: Output<BodyDiagnosticSettingsArgs>) {
        this.body = value
    }

    /**
     * @param value Data masking settings.
     */
    @JvmName("ggmxrjsugivgsdwq")
    public suspend fun dataMasking(`value`: Output<DataMaskingArgs>) {
        this.dataMasking = value
    }

    /**
     * @param value Array of HTTP Headers to log.
     */
    @JvmName("cwpfaxdjkrombsan")
    public suspend fun headers(`value`: Output<List<String>>) {
        this.headers = value
    }

    @JvmName("xqxrcdgcixsggiop")
    public suspend fun headers(vararg values: Output<String>) {
        this.headers = Output.all(values.asList())
    }

    /**
     * @param values Array of HTTP Headers to log.
     */
    @JvmName("pntkspxxejyfyabd")
    public suspend fun headers(values: List<Output<String>>) {
        this.headers = Output.all(values)
    }

    /**
     * @param value Body logging settings.
     */
    @JvmName("lynvgdidsaimhnad")
    public suspend fun body(`value`: BodyDiagnosticSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.body = mapped
    }

    /**
     * @param argument Body logging settings.
     */
    @JvmName("wmxwyrjchwiuspca")
    public suspend fun body(argument: suspend BodyDiagnosticSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = BodyDiagnosticSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.body = mapped
    }

    /**
     * @param value Data masking settings.
     */
    @JvmName("tdmmmltytnpsdyxp")
    public suspend fun dataMasking(`value`: DataMaskingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataMasking = mapped
    }

    /**
     * @param argument Data masking settings.
     */
    @JvmName("mikvowdiwtlqdkfx")
    public suspend fun dataMasking(argument: suspend DataMaskingArgsBuilder.() -> Unit) {
        val toBeMapped = DataMaskingArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dataMasking = mapped
    }

    /**
     * @param value Array of HTTP Headers to log.
     */
    @JvmName("oskueudquryroicm")
    public suspend fun headers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param values Array of HTTP Headers to log.
     */
    @JvmName("ngpvygojhtcjdhnm")
    public suspend fun headers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    internal fun build(): HttpMessageDiagnosticArgs = HttpMessageDiagnosticArgs(
        body = body,
        dataMasking = dataMasking,
        headers = headers,
    )
}
