@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.ListGatewayDebugCredentialsPlainArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.enums.GatewayListDebugCredentialsContractPurpose
import com.pulumi.core.Either
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property apiId Full resource Id of an API.
 * @property credentialsExpireAfter Credentials expiration in ISO8601 format. Maximum duration of the credentials is PT1H. When property is not specified, them value PT1H is used.
 * @property gatewayId Gateway entity identifier. Must be unique in the current API Management service instance. Must not have value 'managed'
 * @property purposes Purposes of debug credential.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 */
public data class ListGatewayDebugCredentialsPlainArgs(
    public val apiId: String,
    public val credentialsExpireAfter: String? = null,
    public val gatewayId: String,
    public val purposes: List<Either<String, GatewayListDebugCredentialsContractPurpose>>,
    public val resourceGroupName: String,
    public val serviceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.ListGatewayDebugCredentialsPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.apimanagement.inputs.ListGatewayDebugCredentialsPlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.ListGatewayDebugCredentialsPlainArgs.builder()
            .apiId(apiId.let({ args0 -> args0 }))
            .credentialsExpireAfter(credentialsExpireAfter?.let({ args0 -> args0 }))
            .gatewayId(gatewayId.let({ args0 -> args0 }))
            .purposes(
                purposes.let({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 ->
                            args0.let({ args0 -> args0.toJava() })
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListGatewayDebugCredentialsPlainArgs].
 */
@PulumiTagMarker
public class ListGatewayDebugCredentialsPlainArgsBuilder internal constructor() {
    private var apiId: String? = null

    private var credentialsExpireAfter: String? = null

    private var gatewayId: String? = null

    private var purposes: List<Either<String, GatewayListDebugCredentialsContractPurpose>>? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    /**
     * @param value Full resource Id of an API.
     */
    @JvmName("trqqcvqpnciacibg")
    public suspend fun apiId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.apiId = mapped
    }

    /**
     * @param value Credentials expiration in ISO8601 format. Maximum duration of the credentials is PT1H. When property is not specified, them value PT1H is used.
     */
    @JvmName("niotjomnydnfrgws")
    public suspend fun credentialsExpireAfter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.credentialsExpireAfter = mapped
    }

    /**
     * @param value Gateway entity identifier. Must be unique in the current API Management service instance. Must not have value 'managed'
     */
    @JvmName("fsisuvwoyukyffcv")
    public suspend fun gatewayId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.gatewayId = mapped
    }

    /**
     * @param value Purposes of debug credential.
     */
    @JvmName("lgvwbyoriapsxrth")
    public suspend
    fun purposes(`value`: List<Either<String, GatewayListDebugCredentialsContractPurpose>>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.purposes = mapped
    }

    /**
     * @param values Purposes of debug credential.
     */
    @JvmName("omshimchywwpibpq")
    public suspend fun purposes(
        vararg
        values: Either<String, GatewayListDebugCredentialsContractPurpose>,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.purposes = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wsqqppgsphfttevs")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("rpeitbhclfroflmp")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): ListGatewayDebugCredentialsPlainArgs = ListGatewayDebugCredentialsPlainArgs(
        apiId = apiId ?: throw PulumiNullFieldException("apiId"),
        credentialsExpireAfter = credentialsExpireAfter,
        gatewayId = gatewayId ?: throw PulumiNullFieldException("gatewayId"),
        purposes = purposes ?: throw PulumiNullFieldException("purposes"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
