@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.ListPolicyFragmentReferencesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id A resource identifier.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property skip Number of records to skip.
 * @property top Number of records to return.
 */
public data class ListPolicyFragmentReferencesPlainArgs(
    public val id: String,
    public val resourceGroupName: String,
    public val serviceName: String,
    public val skip: Int? = null,
    public val top: Int? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.ListPolicyFragmentReferencesPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.apimanagement.inputs.ListPolicyFragmentReferencesPlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.ListPolicyFragmentReferencesPlainArgs.builder()
            .id(id.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 }))
            .skip(skip?.let({ args0 -> args0 }))
            .top(top?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListPolicyFragmentReferencesPlainArgs].
 */
@PulumiTagMarker
public class ListPolicyFragmentReferencesPlainArgsBuilder internal constructor() {
    private var id: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    private var skip: Int? = null

    private var top: Int? = null

    /**
     * @param value A resource identifier.
     */
    @JvmName("vgxptouiveteabyt")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sbknekqhvlqsisuh")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("vabxooenvexuqoax")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    /**
     * @param value Number of records to skip.
     */
    @JvmName("wiypqbypklefwxct")
    public suspend fun skip(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.skip = mapped
    }

    /**
     * @param value Number of records to return.
     */
    @JvmName("xpbbsnfbbhepbifp")
    public suspend fun top(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.top = mapped
    }

    internal fun build(): ListPolicyFragmentReferencesPlainArgs =
        ListPolicyFragmentReferencesPlainArgs(
            id = id ?: throw PulumiNullFieldException("id"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
            skip = skip,
            top = top,
        )
}
