@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.PipelineDiagnosticSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Diagnostic settings for incoming/outgoing HTTP messages to the Gateway.
 * @property request Diagnostic settings for request.
 * @property response Diagnostic settings for response.
 */
public data class PipelineDiagnosticSettingsArgs(
    public val request: Output<HttpMessageDiagnosticArgs>? = null,
    public val response: Output<HttpMessageDiagnosticArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.PipelineDiagnosticSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.PipelineDiagnosticSettingsArgs =
        com.pulumi.azurenative.apimanagement.inputs.PipelineDiagnosticSettingsArgs.builder()
            .request(request?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .response(response?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [PipelineDiagnosticSettingsArgs].
 */
@PulumiTagMarker
public class PipelineDiagnosticSettingsArgsBuilder internal constructor() {
    private var request: Output<HttpMessageDiagnosticArgs>? = null

    private var response: Output<HttpMessageDiagnosticArgs>? = null

    /**
     * @param value Diagnostic settings for request.
     */
    @JvmName("uvyrjcgmreiwmtgy")
    public suspend fun request(`value`: Output<HttpMessageDiagnosticArgs>) {
        this.request = value
    }

    /**
     * @param value Diagnostic settings for response.
     */
    @JvmName("pnntrslqqpkgiayl")
    public suspend fun response(`value`: Output<HttpMessageDiagnosticArgs>) {
        this.response = value
    }

    /**
     * @param value Diagnostic settings for request.
     */
    @JvmName("lnqrhoswuukjwgky")
    public suspend fun request(`value`: HttpMessageDiagnosticArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.request = mapped
    }

    /**
     * @param argument Diagnostic settings for request.
     */
    @JvmName("yfuhxwltshuwvryu")
    public suspend fun request(argument: suspend HttpMessageDiagnosticArgsBuilder.() -> Unit) {
        val toBeMapped = HttpMessageDiagnosticArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.request = mapped
    }

    /**
     * @param value Diagnostic settings for response.
     */
    @JvmName("qtnjxrlvqvfxclmt")
    public suspend fun response(`value`: HttpMessageDiagnosticArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.response = mapped
    }

    /**
     * @param argument Diagnostic settings for response.
     */
    @JvmName("uodvqkhpcpriwbwg")
    public suspend fun response(argument: suspend HttpMessageDiagnosticArgsBuilder.() -> Unit) {
        val toBeMapped = HttpMessageDiagnosticArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.response = mapped
    }

    internal fun build(): PipelineDiagnosticSettingsArgs = PipelineDiagnosticSettingsArgs(
        request = request,
        response = response,
    )
}
