@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.TokenBodyParameterContractArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * OAuth acquire token request body parameter (www-url-form-encoded).
 * @property name body parameter name.
 * @property value body parameter value.
 */
public data class TokenBodyParameterContractArgs(
    public val name: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.TokenBodyParameterContractArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.TokenBodyParameterContractArgs =
        com.pulumi.azurenative.apimanagement.inputs.TokenBodyParameterContractArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TokenBodyParameterContractArgs].
 */
@PulumiTagMarker
public class TokenBodyParameterContractArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value body parameter name.
     */
    @JvmName("qnarpmwrgwysehkn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value body parameter value.
     */
    @JvmName("qfaqnwnrreqckvvf")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value body parameter name.
     */
    @JvmName("euwdvmhvwlweiopv")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value body parameter value.
     */
    @JvmName("qogsxqslmwnescgg")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): TokenBodyParameterContractArgs = TokenBodyParameterContractArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
