@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * API contact information
 * @property email The email address of the contact person/organization. MUST be in the format of an email address
 * @property name The identifying name of the contact person/organization
 * @property url The URL pointing to the contact information. MUST be in the format of a URL
 */
public data class ApiContactInformationResponse(
    public val email: String? = null,
    public val name: String? = null,
    public val url: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.ApiContactInformationResponse):
            ApiContactInformationResponse = ApiContactInformationResponse(
            email = javaType.email().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            url = javaType.url().map({ args0 -> args0 }).orElse(null),
        )
    }
}
