@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Authorization error details.
 * @property code Error code
 * @property message Error message
 */
public data class AuthorizationErrorResponse(
    public val code: String? = null,
    public val message: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.AuthorizationErrorResponse):
            AuthorizationErrorResponse = AuthorizationErrorResponse(
            code = javaType.code().map({ args0 -> args0 }).orElse(null),
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
        )
    }
}
