@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * Properties controlling TLS Certificate Validation.
 * @property validateCertificateChain Flag indicating whether SSL certificate chain validation should be done when using self-signed certificates for this backend host.
 * @property validateCertificateName Flag indicating whether SSL certificate name validation should be done when using self-signed certificates for this backend host.
 */
public data class BackendTlsPropertiesResponse(
    public val validateCertificateChain: Boolean? = null,
    public val validateCertificateName: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.BackendTlsPropertiesResponse):
            BackendTlsPropertiesResponse = BackendTlsPropertiesResponse(
            validateCertificateChain = javaType.validateCertificateChain().map({ args0 -> args0 }).orElse(null),
            validateCertificateName = javaType.validateCertificateName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
