@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Email Template Parameter contract.
 * @property description Template parameter description.
 * @property name Template parameter name.
 * @property title Template parameter title.
 */
public data class EmailTemplateParametersContractPropertiesResponse(
    public val description: String? = null,
    public val name: String? = null,
    public val title: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.EmailTemplateParametersContractPropertiesResponse):
            EmailTemplateParametersContractPropertiesResponse =
            EmailTemplateParametersContractPropertiesResponse(
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                title = javaType.title().map({ args0 -> args0 }).orElse(null),
            )
    }
}
