@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * External OAuth authorization server settings.
 * @property authorizationEndpoint OAuth authorization endpoint. See http://tools.ietf.org/html/rfc6749#section-3.2.
 * @property authorizationMethods HTTP verbs supported by the authorization endpoint. GET must be always present. POST is optional.
 * @property bearerTokenSendingMethods Specifies the mechanism by which access token is passed to the API.
 * @property clientAuthenticationMethod Method of authentication supported by the token endpoint of this authorization server. Possible values are Basic and/or Body. When Body is specified, client credentials and other parameters are passed within the request body in the application/x-www-form-urlencoded format.
 * @property clientId Client or app id registered with this authorization server.
 * @property clientRegistrationEndpoint Optional reference to a page where client or app registration for this authorization server is performed. Contains absolute URL to entity being referenced.
 * @property clientSecret Client or app secret registered with this authorization server. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get the value.
 * @property defaultScope Access token scope that is going to be requested by default. Can be overridden at the API level. Should be provided in the form of a string containing space-delimited values.
 * @property description Description of the authorization server. Can contain HTML formatting tags.
 * @property displayName User-friendly authorization server name.
 * @property grantTypes Form of an authorization grant, which the client uses to request the access token.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property resourceOwnerPassword Can be optionally specified when resource owner password grant type is supported by this authorization server. Default resource owner password.
 * @property resourceOwnerUsername Can be optionally specified when resource owner password grant type is supported by this authorization server. Default resource owner username.
 * @property supportState If true, authorization server will include state parameter from the authorization request to its response. Client may use state parameter to raise protocol security.
 * @property tokenBodyParameters Additional parameters required by the token endpoint of this authorization server represented as an array of JSON objects with name and value string properties, i.e. {"name" : "name value", "value": "a value"}.
 * @property tokenEndpoint OAuth token endpoint. Contains absolute URI to entity being referenced.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property useInApiDocumentation If true, the authorization server will be used in the API documentation in the developer portal. False by default if no value is provided.
 * @property useInTestConsole If true, the authorization server may be used in the developer portal test console. True by default if no value is provided.
 */
public data class GetAuthorizationServerResult(
    public val authorizationEndpoint: String,
    public val authorizationMethods: List<String>? = null,
    public val bearerTokenSendingMethods: List<String>? = null,
    public val clientAuthenticationMethod: List<String>? = null,
    public val clientId: String,
    public val clientRegistrationEndpoint: String,
    public val clientSecret: String? = null,
    public val defaultScope: String? = null,
    public val description: String? = null,
    public val displayName: String,
    public val grantTypes: List<String>,
    public val id: String,
    public val name: String,
    public val resourceOwnerPassword: String? = null,
    public val resourceOwnerUsername: String? = null,
    public val supportState: Boolean? = null,
    public val tokenBodyParameters: List<TokenBodyParameterContractResponse>? = null,
    public val tokenEndpoint: String? = null,
    public val type: String,
    public val useInApiDocumentation: Boolean? = null,
    public val useInTestConsole: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.GetAuthorizationServerResult):
            GetAuthorizationServerResult = GetAuthorizationServerResult(
            authorizationEndpoint = javaType.authorizationEndpoint(),
            authorizationMethods = javaType.authorizationMethods().map({ args0 -> args0 }),
            bearerTokenSendingMethods = javaType.bearerTokenSendingMethods().map({ args0 -> args0 }),
            clientAuthenticationMethod = javaType.clientAuthenticationMethod().map({ args0 -> args0 }),
            clientId = javaType.clientId(),
            clientRegistrationEndpoint = javaType.clientRegistrationEndpoint(),
            clientSecret = javaType.clientSecret().map({ args0 -> args0 }).orElse(null),
            defaultScope = javaType.defaultScope().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName(),
            grantTypes = javaType.grantTypes().map({ args0 -> args0 }),
            id = javaType.id(),
            name = javaType.name(),
            resourceOwnerPassword = javaType.resourceOwnerPassword().map({ args0 -> args0 }).orElse(null),
            resourceOwnerUsername = javaType.resourceOwnerUsername().map({ args0 -> args0 }).orElse(null),
            supportState = javaType.supportState().map({ args0 -> args0 }).orElse(null),
            tokenBodyParameters = javaType.tokenBodyParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.TokenBodyParameterContractResponse.Companion.toKotlin(args0)
                })
            }),
            tokenEndpoint = javaType.tokenEndpoint().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            useInApiDocumentation = javaType.useInApiDocumentation().map({ args0 -> args0 }).orElse(null),
            useInTestConsole = javaType.useInTestConsole().map({ args0 -> args0 }).orElse(null),
        )
    }
}
