@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Cache details.
 * @property connectionString Runtime connection string to cache
 * @property description Cache description
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property resourceId Original uri of entity in external system cache points to
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property useFromLocation Location identifier to use cache from (should be either 'default' or valid Azure region identifier)
 */
public data class GetCacheResult(
    public val connectionString: String,
    public val description: String? = null,
    public val id: String,
    public val name: String,
    public val resourceId: String? = null,
    public val type: String,
    public val useFromLocation: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.GetCacheResult):
            GetCacheResult = GetCacheResult(
            connectionString = javaType.connectionString(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            useFromLocation = javaType.useFromLocation(),
        )
    }
}
