@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Diagnostic details.
 * @property alwaysLog Specifies for what type of messages sampling settings should not apply.
 * @property backend Diagnostic settings for incoming/outgoing HTTP messages to the Backend
 * @property frontend Diagnostic settings for incoming/outgoing HTTP messages to the Gateway.
 * @property httpCorrelationProtocol Sets correlation protocol to use for Application Insights diagnostics.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property logClientIp Log the ClientIP. Default is false.
 * @property loggerId Resource Id of a target logger.
 * @property metrics Emit custom metrics via emit-metric policy. Applicable only to Application Insights diagnostic settings.
 * @property name The name of the resource
 * @property operationNameFormat The format of the Operation Name for Application Insights telemetries. Default is Name.
 * @property sampling Sampling settings for Diagnostic.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property verbosity The verbosity level applied to traces emitted by trace policies.
 */
public data class GetDiagnosticResult(
    public val alwaysLog: String? = null,
    public val backend: PipelineDiagnosticSettingsResponse? = null,
    public val frontend: PipelineDiagnosticSettingsResponse? = null,
    public val httpCorrelationProtocol: String? = null,
    public val id: String,
    public val logClientIp: Boolean? = null,
    public val loggerId: String,
    public val metrics: Boolean? = null,
    public val name: String,
    public val operationNameFormat: String? = null,
    public val sampling: SamplingSettingsResponse? = null,
    public val type: String,
    public val verbosity: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.GetDiagnosticResult):
            GetDiagnosticResult = GetDiagnosticResult(
            alwaysLog = javaType.alwaysLog().map({ args0 -> args0 }).orElse(null),
            backend = javaType.backend().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.PipelineDiagnosticSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            frontend = javaType.frontend().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.PipelineDiagnosticSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            httpCorrelationProtocol = javaType.httpCorrelationProtocol().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            logClientIp = javaType.logClientIp().map({ args0 -> args0 }).orElse(null),
            loggerId = javaType.loggerId(),
            metrics = javaType.metrics().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            operationNameFormat = javaType.operationNameFormat().map({ args0 -> args0 }).orElse(null),
            sampling = javaType.sampling().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.SamplingSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
            verbosity = javaType.verbosity().map({ args0 -> args0 }).orElse(null),
        )
    }
}
