@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Tag-operation link details.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property operationId Full resource Id of an API operation.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetWorkspaceTagOperationLinkResult(
    public val id: String,
    public val name: String,
    public val operationId: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.GetWorkspaceTagOperationLinkResult):
            GetWorkspaceTagOperationLinkResult = GetWorkspaceTagOperationLinkResult(
            id = javaType.id(),
            name = javaType.name(),
            operationId = javaType.operationId(),
            type = javaType.type(),
        )
    }
}
