@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Custom hostname configuration.
 * @property certificate Certificate information.
 * @property certificatePassword Certificate Password.
 * @property certificateSource Certificate Source.
 * @property certificateStatus Certificate Status.
 * @property defaultSslBinding Specify true to setup the certificate associated with this Hostname as the Default SSL Certificate. If a client does not send the SNI header, then this will be the certificate that will be challenged. The property is useful if a service has multiple custom hostname enabled and it needs to decide on the default ssl certificate. The setting only applied to gateway Hostname Type.
 * @property encodedCertificate Base64 Encoded certificate.
 * @property hostName Hostname to configure on the Api Management service.
 * @property identityClientId System or User Assigned Managed identity clientId as generated by Azure AD, which has GET access to the keyVault containing the SSL certificate.
 * @property keyVaultId Url to the KeyVault Secret containing the Ssl Certificate. If absolute Url containing version is provided, auto-update of ssl certificate will not work. This requires Api Management service to be configured with aka.ms/apimmsi. The secret should be of type *application/x-pkcs12*
 * @property negotiateClientCertificate Specify true to always negotiate client certificate on the hostname. Default Value is false.
 * @property type Hostname type.
 */
public data class HostnameConfigurationResponse(
    public val certificate: CertificateInformationResponse? = null,
    public val certificatePassword: String? = null,
    public val certificateSource: String? = null,
    public val certificateStatus: String? = null,
    public val defaultSslBinding: Boolean? = null,
    public val encodedCertificate: String? = null,
    public val hostName: String,
    public val identityClientId: String? = null,
    public val keyVaultId: String? = null,
    public val negotiateClientCertificate: Boolean? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.HostnameConfigurationResponse):
            HostnameConfigurationResponse = HostnameConfigurationResponse(
            certificate = javaType.certificate().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.CertificateInformationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            certificatePassword = javaType.certificatePassword().map({ args0 -> args0 }).orElse(null),
            certificateSource = javaType.certificateSource().map({ args0 -> args0 }).orElse(null),
            certificateStatus = javaType.certificateStatus().map({ args0 -> args0 }).orElse(null),
            defaultSslBinding = javaType.defaultSslBinding().map({ args0 -> args0 }).orElse(null),
            encodedCertificate = javaType.encodedCertificate().map({ args0 -> args0 }).orElse(null),
            hostName = javaType.hostName(),
            identityClientId = javaType.identityClientId().map({ args0 -> args0 }).orElse(null),
            keyVaultId = javaType.keyVaultId().map({ args0 -> args0 }).orElse(null),
            negotiateClientCertificate = javaType.negotiateClientCertificate().map({ args0 ->
                args0
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
