@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Operation request details.
 * @property description Operation request description.
 * @property headers Collection of operation request headers.
 * @property queryParameters Collection of operation request query parameters.
 * @property representations Collection of operation request representations.
 */
public data class RequestContractResponse(
    public val description: String? = null,
    public val headers: List<ParameterContractResponse>? = null,
    public val queryParameters: List<ParameterContractResponse>? = null,
    public val representations: List<RepresentationContractResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.RequestContractResponse):
            RequestContractResponse = RequestContractResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            headers = javaType.headers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.ParameterContractResponse.Companion.toKotlin(args0)
                })
            }),
            queryParameters = javaType.queryParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.ParameterContractResponse.Companion.toKotlin(args0)
                })
            }),
            representations = javaType.representations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.RepresentationContractResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
