@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Resource location data properties.
 * @property city The city or locality where the resource is located.
 * @property countryOrRegion The country or region where the resource is located.
 * @property district The district, state, or province where the resource is located.
 * @property name A canonical name for the geographic or physical location.
 */
public data class ResourceLocationDataContractResponse(
    public val city: String? = null,
    public val countryOrRegion: String? = null,
    public val district: String? = null,
    public val name: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.ResourceLocationDataContractResponse):
            ResourceLocationDataContractResponse = ResourceLocationDataContractResponse(
            city = javaType.city().map({ args0 -> args0 }).orElse(null),
            countryOrRegion = javaType.countryOrRegion().map({ args0 -> args0 }).orElse(null),
            district = javaType.district().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
        )
    }
}
