@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Operation response details.
 * @property description Operation response description.
 * @property headers Collection of operation response headers.
 * @property representations Collection of operation response representations.
 * @property statusCode Operation response HTTP status code.
 */
public data class ResponseContractResponse(
    public val description: String? = null,
    public val headers: List<ParameterContractResponse>? = null,
    public val representations: List<RepresentationContractResponse>? = null,
    public val statusCode: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.ResponseContractResponse):
            ResponseContractResponse = ResponseContractResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            headers = javaType.headers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.ParameterContractResponse.Companion.toKotlin(args0)
                })
            }),
            representations = javaType.representations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.RepresentationContractResponse.Companion.toKotlin(args0)
                })
            }),
            statusCode = javaType.statusCode(),
        )
    }
}
