@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties of server X509Names.
 * @property issuerCertificateThumbprint Thumbprint for the Issuer of the Certificate.
 * @property name Common Name of the Certificate.
 */
public data class X509CertificateNameResponse(
    public val issuerCertificateThumbprint: String? = null,
    public val name: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.X509CertificateNameResponse):
            X509CertificateNameResponse = X509CertificateNameResponse(
            issuerCertificateThumbprint = javaType.issuerCertificateThumbprint().map({ args0 ->
                args0
            }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
