@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin

import com.pulumi.azurenative.app.kotlin.outputs.CustomDomainConfigurationResponse
import com.pulumi.azurenative.app.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.app.kotlin.outputs.CustomDomainConfigurationResponse.Companion.toKotlin as customDomainConfigurationResponseToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ConnectedEnvironment].
 */
@PulumiTagMarker
public class ConnectedEnvironmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConnectedEnvironmentArgs = ConnectedEnvironmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConnectedEnvironmentArgsBuilder.() -> Unit) {
        val builder = ConnectedEnvironmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ConnectedEnvironment {
        val builtJavaResource = com.pulumi.azurenative.app.ConnectedEnvironment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ConnectedEnvironment(builtJavaResource)
    }
}

/**
 * An environment for Kubernetes cluster specialized for web workloads by Azure App Service
 * Azure REST API version: 2022-10-01.
 * Other available API versions: 2023-04-01-preview, 2023-05-01, 2023-05-02-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Create kube environments
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connectedEnvironment = new AzureNative.App.ConnectedEnvironment("connectedEnvironment", new()
 *     {
 *         ConnectedEnvironmentName = "testenv",
 *         CustomDomainConfiguration = new AzureNative.App.Inputs.CustomDomainConfigurationArgs
 *         {
 *             CertificatePassword = "private key password",
 *             CertificateValue = "Y2VydA==",
 *             DnsSuffix = "www.my-name.com",
 *         },
 *         DaprAIConnectionString = "InstrumentationKey=00000000-0000-0000-0000-000000000000;IngestionEndpoint=https://northcentralus-0.in.applicationinsights.azure.com/",
 *         ExtendedLocation = new AzureNative.App.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/examplerg/providers/Microsoft.ExtendedLocation/customLocations/testcustomlocation",
 *             Type = "CustomLocation",
 *         },
 *         Location = "East US",
 *         ResourceGroupName = "examplerg",
 *         StaticIp = "1.2.3.4",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := app.NewConnectedEnvironment(ctx, "connectedEnvironment", &app.ConnectedEnvironmentArgs{
 * 			ConnectedEnvironmentName: pulumi.String("testenv"),
 * 			CustomDomainConfiguration: &app.CustomDomainConfigurationArgs{
 * 				CertificatePassword: pulumi.String("private key password"),
 * 				CertificateValue:    pulumi.String("Y2VydA=="),
 * 				DnsSuffix:           pulumi.String("www.my-name.com"),
 * 			},
 * 			DaprAIConnectionString: pulumi.String("InstrumentationKey=00000000-0000-0000-0000-000000000000;IngestionEndpoint=https://northcentralus-0.in.applicationinsights.azure.com/"),
 * 			ExtendedLocation: &app.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/examplerg/providers/Microsoft.ExtendedLocation/customLocations/testcustomlocation"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Location:          pulumi.String("East US"),
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 			StaticIp:          pulumi.String("1.2.3.4"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.ConnectedEnvironment;
 * import com.pulumi.azurenative.app.ConnectedEnvironmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connectedEnvironment = new ConnectedEnvironment("connectedEnvironment", ConnectedEnvironmentArgs.builder()
 *             .connectedEnvironmentName("testenv")
 *             .customDomainConfiguration(Map.ofEntries(
 *                 Map.entry("certificatePassword", "private key password"),
 *                 Map.entry("certificateValue", "Y2VydA=="),
 *                 Map.entry("dnsSuffix", "www.my-name.com")
 *             ))
 *             .daprAIConnectionString("InstrumentationKey=00000000-0000-0000-0000-000000000000;IngestionEndpoint=https://northcentralus-0.in.applicationinsights.azure.com/")
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/examplerg/providers/Microsoft.ExtendedLocation/customLocations/testcustomlocation"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .location("East US")
 *             .resourceGroupName("examplerg")
 *             .staticIp("1.2.3.4")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:app:ConnectedEnvironment testenv /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.App/connectedEnvironments/{connectedEnvironmentName}
 * ```
 */
public class ConnectedEnvironment internal constructor(
    override val javaResource: com.pulumi.azurenative.app.ConnectedEnvironment,
) : KotlinCustomResource(javaResource, ConnectedEnvironmentMapper) {
    /**
     * Custom domain configuration for the environment
     */
    public val customDomainConfiguration: Output<CustomDomainConfigurationResponse>?
        get() = javaResource.customDomainConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> customDomainConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Application Insights connection string used by Dapr to export Service to Service communication telemetry
     */
    public val daprAIConnectionString: Output<String>?
        get() = javaResource.daprAIConnectionString().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Default Domain Name for the cluster
     */
    public val defaultDomain: Output<String>
        get() = javaResource.defaultDomain().applyValue({ args0 -> args0 })

    /**
     * Any errors that occurred during deployment or deployment validation
     */
    public val deploymentErrors: Output<String>
        get() = javaResource.deploymentErrors().applyValue({ args0 -> args0 })

    /**
     * The complex type of the extended location.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>?
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> extendedLocationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the Kubernetes Environment.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Static IP of the connectedEnvironment
     */
    public val staticIp: Output<String>?
        get() = javaResource.staticIp().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ConnectedEnvironmentMapper : ResourceMapper<ConnectedEnvironment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.app.ConnectedEnvironment::class == javaResource::class

    override fun map(javaResource: Resource): ConnectedEnvironment = ConnectedEnvironment(
        javaResource
            as com.pulumi.azurenative.app.ConnectedEnvironment,
    )
}

/**
 * @see [ConnectedEnvironment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConnectedEnvironment].
 */
public suspend fun connectedEnvironment(
    name: String,
    block: suspend ConnectedEnvironmentResourceBuilder.() -> Unit,
): ConnectedEnvironment {
    val builder = ConnectedEnvironmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConnectedEnvironment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun connectedEnvironment(name: String): ConnectedEnvironment {
    val builder = ConnectedEnvironmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
