@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin

import com.pulumi.azurenative.app.ContainerAppArgs.builder
import com.pulumi.azurenative.app.kotlin.inputs.ConfigurationArgs
import com.pulumi.azurenative.app.kotlin.inputs.ConfigurationArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.app.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.app.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.TemplateArgs
import com.pulumi.azurenative.app.kotlin.inputs.TemplateArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Container App.
 * Azure REST API version: 2022-10-01. Prior API version in Azure Native 1.x: 2022-03-01.
 * Other available API versions: 2022-01-01-preview, 2023-04-01-preview, 2023-05-01, 2023-05-02-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Create or Update Container App
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var containerApp = new AzureNative.App.ContainerApp("containerApp", new()
 *     {
 *         Configuration = new AzureNative.App.Inputs.ConfigurationArgs
 *         {
 *             Dapr = new AzureNative.App.Inputs.DaprArgs
 *             {
 *                 AppPort = 3000,
 *                 AppProtocol = "http",
 *                 EnableApiLogging = true,
 *                 Enabled = true,
 *                 HttpMaxRequestSize = 10,
 *                 HttpReadBufferSize = 30,
 *                 LogLevel = "debug",
 *             },
 *             Ingress = new AzureNative.App.Inputs.IngressArgs
 *             {
 *                 ClientCertificateMode = "accept",
 *                 CorsPolicy = new AzureNative.App.Inputs.CorsPolicyArgs
 *                 {
 *                     AllowCredentials = true,
 *                     AllowedHeaders = new[]
 *                     {
 *                         "HEADER1",
 *                         "HEADER2",
 *                     },
 *                     AllowedMethods = new[]
 *                     {
 *                         "GET",
 *                         "POST",
 *                     },
 *                     AllowedOrigins = new[]
 *                     {
 *                         "https://a.test.com",
 *                         "https://b.test.com",
 *                     },
 *                     ExposeHeaders = new[]
 *                     {
 *                         "HEADER3",
 *                         "HEADER4",
 *                     },
 *                     MaxAge = 1234,
 *                 },
 *                 CustomDomains = new[]
 *                 {
 *                     new AzureNative.App.Inputs.CustomDomainArgs
 *                     {
 *                         BindingType = "SniEnabled",
 *                         CertificateId = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.App/managedEnvironments/demokube/certificates/my-certificate-for-my-name-dot-com",
 *                         Name = "www.my-name.com",
 *                     },
 *                     new AzureNative.App.Inputs.CustomDomainArgs
 *                     {
 *                         BindingType = "SniEnabled",
 *                         CertificateId = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.App/managedEnvironments/demokube/certificates/my-certificate-for-my-other-name-dot-com",
 *                         Name = "www.my-other-name.com",
 *                     },
 *                 },
 *                 External = true,
 *                 IpSecurityRestrictions = new[]
 *                 {
 *                     new AzureNative.App.Inputs.IpSecurityRestrictionRuleArgs
 *                     {
 *                         Action = "Allow",
 *                         Description = "Allowing all IP's within the subnet below to access containerapp",
 *                         IpAddressRange = "192.168.1.1/32",
 *                         Name = "Allow work IP A subnet",
 *                     },
 *                     new AzureNative.App.Inputs.IpSecurityRestrictionRuleArgs
 *                     {
 *                         Action = "Allow",
 *                         Description = "Allowing all IP's within the subnet below to access containerapp",
 *                         IpAddressRange = "192.168.1.1/8",
 *                         Name = "Allow work IP B subnet",
 *                     },
 *                 },
 *                 TargetPort = 3000,
 *                 Traffic = new[]
 *                 {
 *                     new AzureNative.App.Inputs.TrafficWeightArgs
 *                     {
 *                         Label = "production",
 *                         RevisionName = "testcontainerApp0-ab1234",
 *                         Weight = 100,
 *                     },
 *                 },
 *             },
 *             MaxInactiveRevisions = 10,
 *         },
 *         ContainerAppName = "testcontainerApp0",
 *         EnvironmentId = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.App/managedEnvironments/demokube",
 *         Location = "East US",
 *         ResourceGroupName = "rg",
 *         Template = new AzureNative.App.Inputs.TemplateArgs
 *         {
 *             Containers = new[]
 *             {
 *                 new AzureNative.App.Inputs.ContainerArgs
 *                 {
 *                     Image = "repo/testcontainerApp0:v1",
 *                     Name = "testcontainerApp0",
 *                     Probes = new[]
 *                     {
 *                         new AzureNative.App.Inputs.ContainerAppProbeArgs
 *                         {
 *                             HttpGet = new AzureNative.App.Inputs.ContainerAppProbeHttpGetArgs
 *                             {
 *                                 HttpHeaders = new[]
 *                                 {
 *                                     new AzureNative.App.Inputs.ContainerAppProbeHttpHeadersArgs
 *                                     {
 *                                         Name = "Custom-Header",
 *                                         Value = "Awesome",
 *                                     },
 *                                 },
 *                                 Path = "/health",
 *                                 Port = 8080,
 *                             },
 *                             InitialDelaySeconds = 3,
 *                             PeriodSeconds = 3,
 *                             Type = "Liveness",
 *                         },
 *                     },
 *                 },
 *             },
 *             InitContainers = new[]
 *             {
 *                 new AzureNative.App.Inputs.InitContainerArgs
 *                 {
 *                     Args = new[]
 *                     {
 *                         "-c",
 *                         "while true; do echo hello; sleep 10;done",
 *                     },
 *                     Command = new[]
 *                     {
 *                         "/bin/sh",
 *                     },
 *                     Image = "repo/testcontainerApp0:v4",
 *                     Name = "testinitcontainerApp0",
 *                     Resources = new AzureNative.App.Inputs.ContainerResourcesArgs
 *                     {
 *                         Cpu = 0.2,
 *                         Memory = "100Mi",
 *                     },
 *                 },
 *             },
 *             Scale = new AzureNative.App.Inputs.ScaleArgs
 *             {
 *                 MaxReplicas = 5,
 *                 MinReplicas = 1,
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.App.Inputs.ScaleRuleArgs
 *                     {
 *                         Custom = new AzureNative.App.Inputs.CustomScaleRuleArgs
 *                         {
 *                             Metadata =
 *                             {
 *                                 { "concurrentRequests", "50" },
 *                             },
 *                             Type = "http",
 *                         },
 *                         Name = "httpscalingrule",
 *                     },
 *                 },
 *             },
 *         },
 *         WorkloadProfileType = "GeneralPurpose",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := app.NewContainerApp(ctx, "containerApp", &app.ContainerAppArgs{
 * Configuration: app.ConfigurationResponse{
 * Dapr: &app.DaprArgs{
 * AppPort: pulumi.Int(3000),
 * AppProtocol: pulumi.String("http"),
 * EnableApiLogging: pulumi.Bool(true),
 * Enabled: pulumi.Bool(true),
 * HttpMaxRequestSize: pulumi.Int(10),
 * HttpReadBufferSize: pulumi.Int(30),
 * LogLevel: pulumi.String("debug"),
 * },
 * Ingress: interface{}{
 * ClientCertificateMode: pulumi.String("accept"),
 * CorsPolicy: &app.CorsPolicyArgs{
 * AllowCredentials: pulumi.Bool(true),
 * AllowedHeaders: pulumi.StringArray{
 * pulumi.String("HEADER1"),
 * pulumi.String("HEADER2"),
 * },
 * AllowedMethods: pulumi.StringArray{
 * pulumi.String("GET"),
 * pulumi.String("POST"),
 * },
 * AllowedOrigins: pulumi.StringArray{
 * pulumi.String("https://a.test.com"),
 * pulumi.String("https://b.test.com"),
 * },
 * ExposeHeaders: pulumi.StringArray{
 * pulumi.String("HEADER3"),
 * pulumi.String("HEADER4"),
 * },
 * MaxAge: pulumi.Int(1234),
 * },
 * CustomDomains: app.CustomDomainArray{
 * &app.CustomDomainArgs{
 * BindingType: pulumi.String("SniEnabled"),
 * CertificateId: pulumi.String("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.App/managedEnvironments/demokube/certificates/my-certificate-for-my-name-dot-com"),
 * Name: pulumi.String("www.my-name.com"),
 * },
 * &app.CustomDomainArgs{
 * BindingType: pulumi.String("SniEnabled"),
 * CertificateId: pulumi.String("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.App/managedEnvironments/demokube/certificates/my-certificate-for-my-other-name-dot-com"),
 * Name: pulumi.String("www.my-other-name.com"),
 * },
 * },
 * External: pulumi.Bool(true),
 * IpSecurityRestrictions: app.IpSecurityRestrictionRuleArray{
 * &app.IpSecurityRestrictionRuleArgs{
 * Action: pulumi.String("Allow"),
 * Description: pulumi.String("Allowing all IP's within the subnet below to access containerapp"),
 * IpAddressRange: pulumi.String("192.168.1.1/32"),
 * Name: pulumi.String("Allow work IP A subnet"),
 * },
 * &app.IpSecurityRestrictionRuleArgs{
 * Action: pulumi.String("Allow"),
 * Description: pulumi.String("Allowing all IP's within the subnet below to access containerapp"),
 * IpAddressRange: pulumi.String("192.168.1.1/8"),
 * Name: pulumi.String("Allow work IP B subnet"),
 * },
 * },
 * TargetPort: pulumi.Int(3000),
 * Traffic: app.TrafficWeightArray{
 * &app.TrafficWeightArgs{
 * Label: pulumi.String("production"),
 * RevisionName: pulumi.String("testcontainerApp0-ab1234"),
 * Weight: pulumi.Int(100),
 * },
 * },
 * },
 * MaxInactiveRevisions: pulumi.Int(10),
 * },
 * ContainerAppName: pulumi.String("testcontainerApp0"),
 * EnvironmentId: pulumi.String("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.App/managedEnvironments/demokube"),
 * Location: pulumi.String("East US"),
 * ResourceGroupName: pulumi.String("rg"),
 * Template: app.TemplateResponse{
 * Containers: app.ContainerArray{
 * interface{}{
 * Image: pulumi.String("repo/testcontainerApp0:v1"),
 * Name: pulumi.String("testcontainerApp0"),
 * Probes: app.ContainerAppProbeArray{
 * interface{}{
 * HttpGet: interface{}{
 * HttpHeaders: app.ContainerAppProbeHttpHeadersArray{
 * &app.ContainerAppProbeHttpHeadersArgs{
 * Name: pulumi.String("Custom-Header"),
 * Value: pulumi.String("Awesome"),
 * },
 * },
 * Path: pulumi.String("/health"),
 * Port: pulumi.Int(8080),
 * },
 * InitialDelaySeconds: pulumi.Int(3),
 * PeriodSeconds: pulumi.Int(3),
 * Type: pulumi.String("Liveness"),
 * },
 * },
 * },
 * },
 * InitContainers: app.InitContainerArray{
 * interface{}{
 * Args: pulumi.StringArray{
 * pulumi.String("-c"),
 * pulumi.String("while true; do echo hello; sleep 10;done"),
 * },
 * Command: pulumi.StringArray{
 * pulumi.String("/bin/sh"),
 * },
 * Image: pulumi.String("repo/testcontainerApp0:v4"),
 * Name: pulumi.String("testinitcontainerApp0"),
 * Resources: &app.ContainerResourcesArgs{
 * Cpu: pulumi.Float64(0.2),
 * Memory: pulumi.String("100Mi"),
 * },
 * },
 * },
 * Scale: interface{}{
 * MaxReplicas: pulumi.Int(5),
 * MinReplicas: pulumi.Int(1),
 * Rules: app.ScaleRuleArray{
 * interface{}{
 * Custom: &app.CustomScaleRuleArgs{
 * Metadata: pulumi.StringMap{
 * "concurrentRequests": pulumi.String("50"),
 * },
 * Type: pulumi.String("http"),
 * },
 * Name: pulumi.String("httpscalingrule"),
 * },
 * },
 * },
 * },
 * WorkloadProfileType: pulumi.String("GeneralPurpose"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.ContainerApp;
 * import com.pulumi.azurenative.app.ContainerAppArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var containerApp = new ContainerApp("containerApp", ContainerAppArgs.builder()
 *             .configuration(Map.ofEntries(
 *                 Map.entry("dapr", Map.ofEntries(
 *                     Map.entry("appPort", 3000),
 *                     Map.entry("appProtocol", "http"),
 *                     Map.entry("enableApiLogging", true),
 *                     Map.entry("enabled", true),
 *                     Map.entry("httpMaxRequestSize", 10),
 *                     Map.entry("httpReadBufferSize", 30),
 *                     Map.entry("logLevel", "debug")
 *                 )),
 *                 Map.entry("ingress", Map.ofEntries(
 *                     Map.entry("clientCertificateMode", "accept"),
 *                     Map.entry("corsPolicy", Map.ofEntries(
 *                         Map.entry("allowCredentials", true),
 *                         Map.entry("allowedHeaders",
 *                             "HEADER1",
 *                             "HEADER2"),
 *                         Map.entry("allowedMethods",
 *                             "GET",
 *                             "POST"),
 *                         Map.entry("allowedOrigins",
 *                             "https://a.test.com",
 *                             "https://b.test.com"),
 *                         Map.entry("exposeHeaders",
 *                             "HEADER3",
 *                             "HEADER4"),
 *                         Map.entry("maxAge", 1234)
 *                     )),
 *                     Map.entry("customDomains",
 *                         Map.ofEntries(
 *                             Map.entry("bindingType", "SniEnabled"),
 *                             Map.entry("certificateId", "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.App/managedEnvironments/demokube/certificates/my-certificate-for-my-name-dot-com"),
 *                             Map.entry("name", "www.my-name.com")
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("bindingType", "SniEnabled"),
 *                             Map.entry("certificateId", "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.App/managedEnvironments/demokube/certificates/my-certificate-for-my-other-name-dot-com"),
 *                             Map.entry("name", "www.my-other-name.com")
 *                         )),
 *                     Map.entry("external", true),
 *                     Map.entry("ipSecurityRestrictions",
 *                         Map.ofEntries(
 *                             Map.entry("action", "Allow"),
 *                             Map.entry("description", "Allowing all IP's within the subnet below to access containerapp"),
 *                             Map.entry("ipAddressRange", "192.168.1.1/32"),
 *                             Map.entry("name", "Allow work IP A subnet")
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("action", "Allow"),
 *                             Map.entry("description", "Allowing all IP's within the subnet below to access containerapp"),
 *                             Map.entry("ipAddressRange", "192.168.1.1/8"),
 *                             Map.entry("name", "Allow work IP B subnet")
 *                         )),
 *                     Map.entry("targetPort", 3000),
 *                     Map.entry("traffic", Map.ofEntries(
 *                         Map.entry("label", "production"),
 *                         Map.entry("revisionName", "testcontainerApp0-ab1234"),
 *                         Map.entry("weight", 100)
 *                     ))
 *                 )),
 *                 Map.entry("maxInactiveRevisions", 10)
 *             ))
 *             .containerAppName("testcontainerApp0")
 *             .environmentId("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.App/managedEnvironments/demokube")
 *             .location("East US")
 *             .resourceGroupName("rg")
 *             .template(Map.ofEntries(
 *                 Map.entry("containers", Map.ofEntries(
 *                     Map.entry("image", "repo/testcontainerApp0:v1"),
 *                     Map.entry("name", "testcontainerApp0"),
 *                     Map.entry("probes", Map.ofEntries(
 *                         Map.entry("httpGet", Map.ofEntries(
 *                             Map.entry("httpHeaders", Map.ofEntries(
 *                                 Map.entry("name", "Custom-Header"),
 *                                 Map.entry("value", "Awesome")
 *                             )),
 *                             Map.entry("path", "/health"),
 *                             Map.entry("port", 8080)
 *                         )),
 *                         Map.entry("initialDelaySeconds", 3),
 *                         Map.entry("periodSeconds", 3),
 *                         Map.entry("type", "Liveness")
 *                     ))
 *                 )),
 *                 Map.entry("initContainers", Map.ofEntries(
 *                     Map.entry("args",
 *                         "-c",
 *                         "while true; do echo hello; sleep 10;done"),
 *                     Map.entry("command", "/bin/sh"),
 *                     Map.entry("image", "repo/testcontainerApp0:v4"),
 *                     Map.entry("name", "testinitcontainerApp0"),
 *                     Map.entry("resources", Map.ofEntries(
 *                         Map.entry("cpu", 0.2),
 *                         Map.entry("memory", "100Mi")
 *                     ))
 *                 )),
 *                 Map.entry("scale", Map.ofEntries(
 *                     Map.entry("maxReplicas", 5),
 *                     Map.entry("minReplicas", 1),
 *                     Map.entry("rules", Map.ofEntries(
 *                         Map.entry("custom", Map.ofEntries(
 *                             Map.entry("metadata", Map.of("concurrentRequests", "50")),
 *                             Map.entry("type", "http")
 *                         )),
 *                         Map.entry("name", "httpscalingrule")
 *                     ))
 *                 ))
 *             ))
 *             .workloadProfileType("GeneralPurpose")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or Update Tcp App
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var containerApp = new AzureNative.App.ContainerApp("containerApp", new()
 *     {
 *         Configuration = new AzureNative.App.Inputs.ConfigurationArgs
 *         {
 *             Ingress = new AzureNative.App.Inputs.IngressArgs
 *             {
 *                 ExposedPort = 4000,
 *                 External = true,
 *                 TargetPort = 3000,
 *                 Traffic = new[]
 *                 {
 *                     new AzureNative.App.Inputs.TrafficWeightArgs
 *                     {
 *                         RevisionName = "testcontainerAppTcp-ab1234",
 *                         Weight = 100,
 *                     },
 *                 },
 *                 Transport = "tcp",
 *             },
 *         },
 *         ContainerAppName = "testcontainerAppTcp",
 *         EnvironmentId = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.App/managedEnvironments/demokube",
 *         Location = "East US",
 *         ResourceGroupName = "rg",
 *         Template = new AzureNative.App.Inputs.TemplateArgs
 *         {
 *             Containers = new[]
 *             {
 *                 new AzureNative.App.Inputs.ContainerArgs
 *                 {
 *                     Image = "repo/testcontainerAppTcp:v1",
 *                     Name = "testcontainerAppTcp",
 *                     Probes = new[]
 *                     {
 *                         new AzureNative.App.Inputs.ContainerAppProbeArgs
 *                         {
 *                             InitialDelaySeconds = 3,
 *                             PeriodSeconds = 3,
 *                             TcpSocket = new AzureNative.App.Inputs.ContainerAppProbeTcpSocketArgs
 *                             {
 *                                 Port = 8080,
 *                             },
 *                             Type = "Liveness",
 *                         },
 *                     },
 *                 },
 *             },
 *             Scale = new AzureNative.App.Inputs.ScaleArgs
 *             {
 *                 MaxReplicas = 5,
 *                 MinReplicas = 1,
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.App.Inputs.ScaleRuleArgs
 *                     {
 *                         Name = "tcpscalingrule",
 *                         Tcp = new AzureNative.App.Inputs.TcpScaleRuleArgs
 *                         {
 *                             Metadata =
 *                             {
 *                                 { "concurrentConnections", "50" },
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := app.NewContainerApp(ctx, "containerApp", &app.ContainerAppArgs{
 * Configuration: app.ConfigurationResponse{
 * Ingress: interface{}{
 * ExposedPort: pulumi.Int(4000),
 * External: pulumi.Bool(true),
 * TargetPort: pulumi.Int(3000),
 * Traffic: app.TrafficWeightArray{
 * &app.TrafficWeightArgs{
 * RevisionName: pulumi.String("testcontainerAppTcp-ab1234"),
 * Weight: pulumi.Int(100),
 * },
 * },
 * Transport: pulumi.String("tcp"),
 * },
 * },
 * ContainerAppName: pulumi.String("testcontainerAppTcp"),
 * EnvironmentId: pulumi.String("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.App/managedEnvironments/demokube"),
 * Location: pulumi.String("East US"),
 * ResourceGroupName: pulumi.String("rg"),
 * Template: app.TemplateResponse{
 * Containers: app.ContainerArray{
 * interface{}{
 * Image: pulumi.String("repo/testcontainerAppTcp:v1"),
 * Name: pulumi.String("testcontainerAppTcp"),
 * Probes: app.ContainerAppProbeArray{
 * interface{}{
 * InitialDelaySeconds: pulumi.Int(3),
 * PeriodSeconds: pulumi.Int(3),
 * TcpSocket: &app.ContainerAppProbeTcpSocketArgs{
 * Port: pulumi.Int(8080),
 * },
 * Type: pulumi.String("Liveness"),
 * },
 * },
 * },
 * },
 * Scale: interface{}{
 * MaxReplicas: pulumi.Int(5),
 * MinReplicas: pulumi.Int(1),
 * Rules: app.ScaleRuleArray{
 * interface{}{
 * Name: pulumi.String("tcpscalingrule"),
 * Tcp: &app.TcpScaleRuleArgs{
 * Metadata: pulumi.StringMap{
 * "concurrentConnections": pulumi.String("50"),
 * },
 * },
 * },
 * },
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.ContainerApp;
 * import com.pulumi.azurenative.app.ContainerAppArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var containerApp = new ContainerApp("containerApp", ContainerAppArgs.builder()
 *             .configuration(Map.of("ingress", Map.ofEntries(
 *                 Map.entry("exposedPort", 4000),
 *                 Map.entry("external", true),
 *                 Map.entry("targetPort", 3000),
 *                 Map.entry("traffic", Map.ofEntries(
 *                     Map.entry("revisionName", "testcontainerAppTcp-ab1234"),
 *                     Map.entry("weight", 100)
 *                 )),
 *                 Map.entry("transport", "tcp")
 *             )))
 *             .containerAppName("testcontainerAppTcp")
 *             .environmentId("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.App/managedEnvironments/demokube")
 *             .location("East US")
 *             .resourceGroupName("rg")
 *             .template(Map.ofEntries(
 *                 Map.entry("containers", Map.ofEntries(
 *                     Map.entry("image", "repo/testcontainerAppTcp:v1"),
 *                     Map.entry("name", "testcontainerAppTcp"),
 *                     Map.entry("probes", Map.ofEntries(
 *                         Map.entry("initialDelaySeconds", 3),
 *                         Map.entry("periodSeconds", 3),
 *                         Map.entry("tcpSocket", Map.of("port", 8080)),
 *                         Map.entry("type", "Liveness")
 *                     ))
 *                 )),
 *                 Map.entry("scale", Map.ofEntries(
 *                     Map.entry("maxReplicas", 5),
 *                     Map.entry("minReplicas", 1),
 *                     Map.entry("rules", Map.ofEntries(
 *                         Map.entry("name", "tcpscalingrule"),
 *                         Map.entry("tcp", Map.of("metadata", Map.of("concurrentConnections", "50")))
 *                     ))
 *                 ))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:app:ContainerApp testcontainerAppTcp /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/containerApps/{containerAppName}
 * ```
 * @property configuration Non versioned Container App configuration properties.
 * @property containerAppName Name of the Container App.
 * @property environmentId Resource ID of environment.
 * @property extendedLocation The complex type of the extended location.
 * @property identity managed identities for the Container App to interact with other Azure services without maintaining any secrets or credentials in code.
 * @property location The geo-location where the resource lives
 * @property managedEnvironmentId Deprecated. Resource ID of the Container App's environment.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property template Container App versioned application definition.
 * @property workloadProfileType Workload profile type to pin for container app execution.
 */
public data class ContainerAppArgs(
    public val configuration: Output<ConfigurationArgs>? = null,
    public val containerAppName: Output<String>? = null,
    public val environmentId: Output<String>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val managedEnvironmentId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val template: Output<TemplateArgs>? = null,
    public val workloadProfileType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.ContainerAppArgs> {
    override fun toJava(): com.pulumi.azurenative.app.ContainerAppArgs =
        com.pulumi.azurenative.app.ContainerAppArgs.builder()
            .configuration(configuration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .containerAppName(containerAppName?.applyValue({ args0 -> args0 }))
            .environmentId(environmentId?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .managedEnvironmentId(managedEnvironmentId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .template(template?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .workloadProfileType(workloadProfileType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerAppArgs].
 */
@PulumiTagMarker
public class ContainerAppArgsBuilder internal constructor() {
    private var configuration: Output<ConfigurationArgs>? = null

    private var containerAppName: Output<String>? = null

    private var environmentId: Output<String>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var location: Output<String>? = null

    private var managedEnvironmentId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var template: Output<TemplateArgs>? = null

    private var workloadProfileType: Output<String>? = null

    /**
     * @param value Non versioned Container App configuration properties.
     */
    @JvmName("tadjkdykhpaelcfm")
    public suspend fun configuration(`value`: Output<ConfigurationArgs>) {
        this.configuration = value
    }

    /**
     * @param value Name of the Container App.
     */
    @JvmName("tlihlyudpkfanjkj")
    public suspend fun containerAppName(`value`: Output<String>) {
        this.containerAppName = value
    }

    /**
     * @param value Resource ID of environment.
     */
    @JvmName("rsxxawogvnxbnhre")
    public suspend fun environmentId(`value`: Output<String>) {
        this.environmentId = value
    }

    /**
     * @param value The complex type of the extended location.
     */
    @JvmName("mjfwhcnmigxwptps")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value managed identities for the Container App to interact with other Azure services without maintaining any secrets or credentials in code.
     */
    @JvmName("vulwgyoboslpauwd")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("qqlhveokpmcxdvny")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Deprecated. Resource ID of the Container App's environment.
     */
    @JvmName("eosygnkhbcokhgfn")
    public suspend fun managedEnvironmentId(`value`: Output<String>) {
        this.managedEnvironmentId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dgytqfjaqyrtheux")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("fadnifixvoopyoqi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Container App versioned application definition.
     */
    @JvmName("ecphcfleijdgjlvd")
    public suspend fun template(`value`: Output<TemplateArgs>) {
        this.template = value
    }

    /**
     * @param value Workload profile type to pin for container app execution.
     */
    @JvmName("erusmtncmtljehox")
    public suspend fun workloadProfileType(`value`: Output<String>) {
        this.workloadProfileType = value
    }

    /**
     * @param value Non versioned Container App configuration properties.
     */
    @JvmName("lbyrbooeyapgkmra")
    public suspend fun configuration(`value`: ConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param argument Non versioned Container App configuration properties.
     */
    @JvmName("mjhusnufaxiglqew")
    public suspend fun configuration(argument: suspend ConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.configuration = mapped
    }

    /**
     * @param value Name of the Container App.
     */
    @JvmName("yqysfbopnvfqrlsi")
    public suspend fun containerAppName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerAppName = mapped
    }

    /**
     * @param value Resource ID of environment.
     */
    @JvmName("mbxlymwwawfcdqni")
    public suspend fun environmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentId = mapped
    }

    /**
     * @param value The complex type of the extended location.
     */
    @JvmName("njslvmphafkchpgr")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The complex type of the extended location.
     */
    @JvmName("worywvthpwswrado")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value managed identities for the Container App to interact with other Azure services without maintaining any secrets or credentials in code.
     */
    @JvmName("xtfpwaxpgvxaihtf")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument managed identities for the Container App to interact with other Azure services without maintaining any secrets or credentials in code.
     */
    @JvmName("ynongrkyvtixjyex")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("fajnghoxjkfrqsks")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Deprecated. Resource ID of the Container App's environment.
     */
    @JvmName("pmxlismtqtacxdva")
    public suspend fun managedEnvironmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedEnvironmentId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("teaoafixfghjeluu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("gmjjfoxvlakmwhgb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("bfjkptlcchuaupas")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Container App versioned application definition.
     */
    @JvmName("paknhpqjldhmrceh")
    public suspend fun template(`value`: TemplateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.template = mapped
    }

    /**
     * @param argument Container App versioned application definition.
     */
    @JvmName("dkihtejhqpquhvlb")
    public suspend fun template(argument: suspend TemplateArgsBuilder.() -> Unit) {
        val toBeMapped = TemplateArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.template = mapped
    }

    /**
     * @param value Workload profile type to pin for container app execution.
     */
    @JvmName("rwelltmeqgaattii")
    public suspend fun workloadProfileType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workloadProfileType = mapped
    }

    internal fun build(): ContainerAppArgs = ContainerAppArgs(
        configuration = configuration,
        containerAppName = containerAppName,
        environmentId = environmentId,
        extendedLocation = extendedLocation,
        identity = identity,
        location = location,
        managedEnvironmentId = managedEnvironmentId,
        resourceGroupName = resourceGroupName,
        tags = tags,
        template = template,
        workloadProfileType = workloadProfileType,
    )
}
