@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin

import com.pulumi.azurenative.app.kotlin.outputs.AuthPlatformResponse
import com.pulumi.azurenative.app.kotlin.outputs.GlobalValidationResponse
import com.pulumi.azurenative.app.kotlin.outputs.HttpSettingsResponse
import com.pulumi.azurenative.app.kotlin.outputs.IdentityProvidersResponse
import com.pulumi.azurenative.app.kotlin.outputs.LoginResponse
import com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.app.kotlin.outputs.AuthPlatformResponse.Companion.toKotlin as authPlatformResponseToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.GlobalValidationResponse.Companion.toKotlin as globalValidationResponseToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.HttpSettingsResponse.Companion.toKotlin as httpSettingsResponseToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.IdentityProvidersResponse.Companion.toKotlin as identityProvidersResponseToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.LoginResponse.Companion.toKotlin as loginResponseToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ContainerAppsAuthConfig].
 */
@PulumiTagMarker
public class ContainerAppsAuthConfigResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ContainerAppsAuthConfigArgs = ContainerAppsAuthConfigArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ContainerAppsAuthConfigArgsBuilder.() -> Unit) {
        val builder = ContainerAppsAuthConfigArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ContainerAppsAuthConfig {
        val builtJavaResource =
            com.pulumi.azurenative.app.ContainerAppsAuthConfig(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ContainerAppsAuthConfig(builtJavaResource)
    }
}

/**
 * Configuration settings for the Azure ContainerApp Service Authentication / Authorization feature.
 * Azure REST API version: 2022-10-01. Prior API version in Azure Native 1.x: 2022-03-01.
 * Other available API versions: 2022-01-01-preview, 2023-04-01-preview, 2023-05-01, 2023-05-02-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Create or Update Container App AuthConfig
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var containerAppsAuthConfig = new AzureNative.App.ContainerAppsAuthConfig("containerAppsAuthConfig", new()
 *     {
 *         AuthConfigName = "current",
 *         ContainerAppName = "testcanadacentral",
 *         GlobalValidation = new AzureNative.App.Inputs.GlobalValidationArgs
 *         {
 *             UnauthenticatedClientAction = AzureNative.App.UnauthenticatedClientActionV2.AllowAnonymous,
 *         },
 *         IdentityProviders = new AzureNative.App.Inputs.IdentityProvidersArgs
 *         {
 *             Facebook = new AzureNative.App.Inputs.FacebookArgs
 *             {
 *                 Registration = new AzureNative.App.Inputs.AppRegistrationArgs
 *                 {
 *                     AppId = "123",
 *                     AppSecretSettingName = "facebook-secret",
 *                 },
 *             },
 *         },
 *         Platform = new AzureNative.App.Inputs.AuthPlatformArgs
 *         {
 *             Enabled = true,
 *         },
 *         ResourceGroupName = "workerapps-rg-xj",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := app.NewContainerAppsAuthConfig(ctx, "containerAppsAuthConfig", &app.ContainerAppsAuthConfigArgs{
 * AuthConfigName: pulumi.String("current"),
 * ContainerAppName: pulumi.String("testcanadacentral"),
 * GlobalValidation: &app.GlobalValidationArgs{
 * UnauthenticatedClientAction: app.UnauthenticatedClientActionV2AllowAnonymous,
 * },
 * IdentityProviders: app.IdentityProvidersResponse{
 * Facebook: interface{}{
 * Registration: &app.AppRegistrationArgs{
 * AppId: pulumi.String("123"),
 * AppSecretSettingName: pulumi.String("facebook-secret"),
 * },
 * },
 * },
 * Platform: &app.AuthPlatformArgs{
 * Enabled: pulumi.Bool(true),
 * },
 * ResourceGroupName: pulumi.String("workerapps-rg-xj"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.ContainerAppsAuthConfig;
 * import com.pulumi.azurenative.app.ContainerAppsAuthConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var containerAppsAuthConfig = new ContainerAppsAuthConfig("containerAppsAuthConfig", ContainerAppsAuthConfigArgs.builder()
 *             .authConfigName("current")
 *             .containerAppName("testcanadacentral")
 *             .globalValidation(Map.of("unauthenticatedClientAction", "AllowAnonymous"))
 *             .identityProviders(Map.of("facebook", Map.of("registration", Map.ofEntries(
 *                 Map.entry("appId", "123"),
 *                 Map.entry("appSecretSettingName", "facebook-secret")
 *             ))))
 *             .platform(Map.of("enabled", true))
 *             .resourceGroupName("workerapps-rg-xj")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:app:ContainerAppsAuthConfig current /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/containerApps/{containerAppName}/authConfigs/{authConfigName}
 * ```
 */
public class ContainerAppsAuthConfig internal constructor(
    override val javaResource: com.pulumi.azurenative.app.ContainerAppsAuthConfig,
) : KotlinCustomResource(javaResource, ContainerAppsAuthConfigMapper) {
    /**
     * The configuration settings that determines the validation flow of users using  Service Authentication/Authorization.
     */
    public val globalValidation: Output<GlobalValidationResponse>?
        get() = javaResource.globalValidation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> globalValidationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The configuration settings of the HTTP requests for authentication and authorization requests made against ContainerApp Service Authentication/Authorization.
     */
    public val httpSettings: Output<HttpSettingsResponse>?
        get() = javaResource.httpSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    httpSettingsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The configuration settings of each of the identity providers used to configure ContainerApp Service Authentication/Authorization.
     */
    public val identityProviders: Output<IdentityProvidersResponse>?
        get() = javaResource.identityProviders().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> identityProvidersResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The configuration settings of the login flow of users using ContainerApp Service Authentication/Authorization.
     */
    public val login: Output<LoginResponse>?
        get() = javaResource.login().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    loginResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The configuration settings of the platform of ContainerApp Service Authentication/Authorization.
     */
    public val platform: Output<AuthPlatformResponse>?
        get() = javaResource.platform().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    authPlatformResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ContainerAppsAuthConfigMapper : ResourceMapper<ContainerAppsAuthConfig> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.app.ContainerAppsAuthConfig::class == javaResource::class

    override fun map(javaResource: Resource): ContainerAppsAuthConfig =
        ContainerAppsAuthConfig(javaResource as com.pulumi.azurenative.app.ContainerAppsAuthConfig)
}

/**
 * @see [ContainerAppsAuthConfig].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ContainerAppsAuthConfig].
 */
public suspend fun containerAppsAuthConfig(
    name: String,
    block: suspend ContainerAppsAuthConfigResourceBuilder.() -> Unit,
): ContainerAppsAuthConfig {
    val builder = ContainerAppsAuthConfigResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ContainerAppsAuthConfig].
 * @param name The _unique_ name of the resulting resource.
 */
public fun containerAppsAuthConfig(name: String): ContainerAppsAuthConfig {
    val builder = ContainerAppsAuthConfigResourceBuilder()
    builder.name(name)
    return builder.build()
}
