@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin

import com.pulumi.azurenative.app.kotlin.outputs.DaprComponentResiliencyPolicyConfigurationResponse
import com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.app.kotlin.outputs.DaprComponentResiliencyPolicyConfigurationResponse.Companion.toKotlin as daprComponentResiliencyPolicyConfigurationResponseToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [DaprComponentResiliencyPolicy].
 */
@PulumiTagMarker
public class DaprComponentResiliencyPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DaprComponentResiliencyPolicyArgs = DaprComponentResiliencyPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DaprComponentResiliencyPolicyArgsBuilder.() -> Unit) {
        val builder = DaprComponentResiliencyPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DaprComponentResiliencyPolicy {
        val builtJavaResource =
            com.pulumi.azurenative.app.DaprComponentResiliencyPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DaprComponentResiliencyPolicy(builtJavaResource)
    }
}

/**
 * Dapr Component Resiliency Policy.
 * Azure REST API version: 2023-08-01-preview.
 * ## Example Usage
 * ### Create or update dapr component resiliency policy with all options
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var daprComponentResiliencyPolicy = new AzureNative.App.DaprComponentResiliencyPolicy("daprComponentResiliencyPolicy", new()
 *     {
 *         ComponentName = "mydaprcomponent",
 *         EnvironmentName = "myenvironment",
 *         InboundPolicy = new AzureNative.App.Inputs.DaprComponentResiliencyPolicyConfigurationArgs
 *         {
 *             HttpRetryPolicy = new AzureNative.App.Inputs.DaprComponentResiliencyPolicyHttpRetryPolicyConfigurationArgs
 *             {
 *                 MaxRetries = 15,
 *                 RetryBackOff = new AzureNative.App.Inputs.DaprComponentResiliencyPolicyHttpRetryBackOffConfigurationArgs
 *                 {
 *                     InitialDelayInMilliseconds = 2000,
 *                     MaxIntervalInMilliseconds = 5500,
 *                 },
 *             },
 *             TimeoutPolicy = new AzureNative.App.Inputs.DaprComponentResiliencyPolicyTimeoutPolicyConfigurationArgs
 *             {
 *                 ResponseTimeoutInSeconds = 30,
 *             },
 *         },
 *         Name = "myresiliencypolicy",
 *         OutboundPolicy = new AzureNative.App.Inputs.DaprComponentResiliencyPolicyConfigurationArgs
 *         {
 *             HttpRetryPolicy = new AzureNative.App.Inputs.DaprComponentResiliencyPolicyHttpRetryPolicyConfigurationArgs
 *             {
 *                 MaxRetries = 5,
 *                 RetryBackOff = new AzureNative.App.Inputs.DaprComponentResiliencyPolicyHttpRetryBackOffConfigurationArgs
 *                 {
 *                     InitialDelayInMilliseconds = 100,
 *                     MaxIntervalInMilliseconds = 30000,
 *                 },
 *             },
 *             TimeoutPolicy = new AzureNative.App.Inputs.DaprComponentResiliencyPolicyTimeoutPolicyConfigurationArgs
 *             {
 *                 ResponseTimeoutInSeconds = 12,
 *             },
 *         },
 *         ResourceGroupName = "examplerg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := app.NewDaprComponentResiliencyPolicy(ctx, "daprComponentResiliencyPolicy", &app.DaprComponentResiliencyPolicyArgs{
 * ComponentName: pulumi.String("mydaprcomponent"),
 * EnvironmentName: pulumi.String("myenvironment"),
 * InboundPolicy: app.DaprComponentResiliencyPolicyConfigurationResponse{
 * HttpRetryPolicy: interface{}{
 * MaxRetries: pulumi.Int(15),
 * RetryBackOff: &app.DaprComponentResiliencyPolicyHttpRetryBackOffConfigurationArgs{
 * InitialDelayInMilliseconds: pulumi.Int(2000),
 * MaxIntervalInMilliseconds: pulumi.Int(5500),
 * },
 * },
 * TimeoutPolicy: &app.DaprComponentResiliencyPolicyTimeoutPolicyConfigurationArgs{
 * ResponseTimeoutInSeconds: pulumi.Int(30),
 * },
 * },
 * Name: pulumi.String("myresiliencypolicy"),
 * OutboundPolicy: app.DaprComponentResiliencyPolicyConfigurationResponse{
 * HttpRetryPolicy: interface{}{
 * MaxRetries: pulumi.Int(5),
 * RetryBackOff: &app.DaprComponentResiliencyPolicyHttpRetryBackOffConfigurationArgs{
 * InitialDelayInMilliseconds: pulumi.Int(100),
 * MaxIntervalInMilliseconds: pulumi.Int(30000),
 * },
 * },
 * TimeoutPolicy: &app.DaprComponentResiliencyPolicyTimeoutPolicyConfigurationArgs{
 * ResponseTimeoutInSeconds: pulumi.Int(12),
 * },
 * },
 * ResourceGroupName: pulumi.String("examplerg"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.DaprComponentResiliencyPolicy;
 * import com.pulumi.azurenative.app.DaprComponentResiliencyPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var daprComponentResiliencyPolicy = new DaprComponentResiliencyPolicy("daprComponentResiliencyPolicy", DaprComponentResiliencyPolicyArgs.builder()
 *             .componentName("mydaprcomponent")
 *             .environmentName("myenvironment")
 *             .inboundPolicy(Map.ofEntries(
 *                 Map.entry("httpRetryPolicy", Map.ofEntries(
 *                     Map.entry("maxRetries", 15),
 *                     Map.entry("retryBackOff", Map.ofEntries(
 *                         Map.entry("initialDelayInMilliseconds", 2000),
 *                         Map.entry("maxIntervalInMilliseconds", 5500)
 *                     ))
 *                 )),
 *                 Map.entry("timeoutPolicy", Map.of("responseTimeoutInSeconds", 30))
 *             ))
 *             .name("myresiliencypolicy")
 *             .outboundPolicy(Map.ofEntries(
 *                 Map.entry("httpRetryPolicy", Map.ofEntries(
 *                     Map.entry("maxRetries", 5),
 *                     Map.entry("retryBackOff", Map.ofEntries(
 *                         Map.entry("initialDelayInMilliseconds", 100),
 *                         Map.entry("maxIntervalInMilliseconds", 30000)
 *                     ))
 *                 )),
 *                 Map.entry("timeoutPolicy", Map.of("responseTimeoutInSeconds", 12))
 *             ))
 *             .resourceGroupName("examplerg")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update dapr component resiliency policy with outbound policy only
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var daprComponentResiliencyPolicy = new AzureNative.App.DaprComponentResiliencyPolicy("daprComponentResiliencyPolicy", new()
 *     {
 *         ComponentName = "mydaprcomponent",
 *         EnvironmentName = "myenvironment",
 *         Name = "myresiliencypolicy",
 *         OutboundPolicy = new AzureNative.App.Inputs.DaprComponentResiliencyPolicyConfigurationArgs
 *         {
 *             HttpRetryPolicy = new AzureNative.App.Inputs.DaprComponentResiliencyPolicyHttpRetryPolicyConfigurationArgs
 *             {
 *                 MaxRetries = 5,
 *                 RetryBackOff = new AzureNative.App.Inputs.DaprComponentResiliencyPolicyHttpRetryBackOffConfigurationArgs
 *                 {
 *                     InitialDelayInMilliseconds = 100,
 *                     MaxIntervalInMilliseconds = 30000,
 *                 },
 *             },
 *             TimeoutPolicy = new AzureNative.App.Inputs.DaprComponentResiliencyPolicyTimeoutPolicyConfigurationArgs
 *             {
 *                 ResponseTimeoutInSeconds = 12,
 *             },
 *         },
 *         ResourceGroupName = "examplerg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := app.NewDaprComponentResiliencyPolicy(ctx, "daprComponentResiliencyPolicy", &app.DaprComponentResiliencyPolicyArgs{
 * ComponentName: pulumi.String("mydaprcomponent"),
 * EnvironmentName: pulumi.String("myenvironment"),
 * Name: pulumi.String("myresiliencypolicy"),
 * OutboundPolicy: app.DaprComponentResiliencyPolicyConfigurationResponse{
 * HttpRetryPolicy: interface{}{
 * MaxRetries: pulumi.Int(5),
 * RetryBackOff: &app.DaprComponentResiliencyPolicyHttpRetryBackOffConfigurationArgs{
 * InitialDelayInMilliseconds: pulumi.Int(100),
 * MaxIntervalInMilliseconds: pulumi.Int(30000),
 * },
 * },
 * TimeoutPolicy: &app.DaprComponentResiliencyPolicyTimeoutPolicyConfigurationArgs{
 * ResponseTimeoutInSeconds: pulumi.Int(12),
 * },
 * },
 * ResourceGroupName: pulumi.String("examplerg"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.DaprComponentResiliencyPolicy;
 * import com.pulumi.azurenative.app.DaprComponentResiliencyPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var daprComponentResiliencyPolicy = new DaprComponentResiliencyPolicy("daprComponentResiliencyPolicy", DaprComponentResiliencyPolicyArgs.builder()
 *             .componentName("mydaprcomponent")
 *             .environmentName("myenvironment")
 *             .name("myresiliencypolicy")
 *             .outboundPolicy(Map.ofEntries(
 *                 Map.entry("httpRetryPolicy", Map.ofEntries(
 *                     Map.entry("maxRetries", 5),
 *                     Map.entry("retryBackOff", Map.ofEntries(
 *                         Map.entry("initialDelayInMilliseconds", 100),
 *                         Map.entry("maxIntervalInMilliseconds", 30000)
 *                     ))
 *                 )),
 *                 Map.entry("timeoutPolicy", Map.of("responseTimeoutInSeconds", 12))
 *             ))
 *             .resourceGroupName("examplerg")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update dapr component resiliency policy with sparse options
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var daprComponentResiliencyPolicy = new AzureNative.App.DaprComponentResiliencyPolicy("daprComponentResiliencyPolicy", new()
 *     {
 *         ComponentName = "mydaprcomponent",
 *         EnvironmentName = "myenvironment",
 *         InboundPolicy = new AzureNative.App.Inputs.DaprComponentResiliencyPolicyConfigurationArgs
 *         {
 *             HttpRetryPolicy = new AzureNative.App.Inputs.DaprComponentResiliencyPolicyHttpRetryPolicyConfigurationArgs
 *             {
 *                 MaxRetries = 5,
 *                 RetryBackOff = new AzureNative.App.Inputs.DaprComponentResiliencyPolicyHttpRetryBackOffConfigurationArgs
 *                 {
 *                     InitialDelayInMilliseconds = 2000,
 *                     MaxIntervalInMilliseconds = 5500,
 *                 },
 *             },
 *         },
 *         Name = "myresiliencypolicy",
 *         OutboundPolicy = new AzureNative.App.Inputs.DaprComponentResiliencyPolicyConfigurationArgs
 *         {
 *             TimeoutPolicy = new AzureNative.App.Inputs.DaprComponentResiliencyPolicyTimeoutPolicyConfigurationArgs
 *             {
 *                 ResponseTimeoutInSeconds = 12,
 *             },
 *         },
 *         ResourceGroupName = "examplerg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := app.NewDaprComponentResiliencyPolicy(ctx, "daprComponentResiliencyPolicy", &app.DaprComponentResiliencyPolicyArgs{
 * ComponentName: pulumi.String("mydaprcomponent"),
 * EnvironmentName: pulumi.String("myenvironment"),
 * InboundPolicy: app.DaprComponentResiliencyPolicyConfigurationResponse{
 * HttpRetryPolicy: interface{}{
 * MaxRetries: pulumi.Int(5),
 * RetryBackOff: &app.DaprComponentResiliencyPolicyHttpRetryBackOffConfigurationArgs{
 * InitialDelayInMilliseconds: pulumi.Int(2000),
 * MaxIntervalInMilliseconds: pulumi.Int(5500),
 * },
 * },
 * },
 * Name: pulumi.String("myresiliencypolicy"),
 * OutboundPolicy: app.DaprComponentResiliencyPolicyConfigurationResponse{
 * TimeoutPolicy: &app.DaprComponentResiliencyPolicyTimeoutPolicyConfigurationArgs{
 * ResponseTimeoutInSeconds: pulumi.Int(12),
 * },
 * },
 * ResourceGroupName: pulumi.String("examplerg"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.DaprComponentResiliencyPolicy;
 * import com.pulumi.azurenative.app.DaprComponentResiliencyPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var daprComponentResiliencyPolicy = new DaprComponentResiliencyPolicy("daprComponentResiliencyPolicy", DaprComponentResiliencyPolicyArgs.builder()
 *             .componentName("mydaprcomponent")
 *             .environmentName("myenvironment")
 *             .inboundPolicy(Map.of("httpRetryPolicy", Map.ofEntries(
 *                 Map.entry("maxRetries", 5),
 *                 Map.entry("retryBackOff", Map.ofEntries(
 *                     Map.entry("initialDelayInMilliseconds", 2000),
 *                     Map.entry("maxIntervalInMilliseconds", 5500)
 *                 ))
 *             )))
 *             .name("myresiliencypolicy")
 *             .outboundPolicy(Map.of("timeoutPolicy", Map.of("responseTimeoutInSeconds", 12)))
 *             .resourceGroupName("examplerg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:app:DaprComponentResiliencyPolicy myresiliencypolicy /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/managedEnvironments/{environmentName}/daprComponents/{componentName}/resiliencyPolicies/{name}
 * ```
 */
public class DaprComponentResiliencyPolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.app.DaprComponentResiliencyPolicy,
) : KotlinCustomResource(javaResource, DaprComponentResiliencyPolicyMapper) {
    /**
     * The optional inbound component resiliency policy configuration
     */
    public val inboundPolicy: Output<DaprComponentResiliencyPolicyConfigurationResponse>?
        get() = javaResource.inboundPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    daprComponentResiliencyPolicyConfigurationResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The optional outbound component resiliency policy configuration
     */
    public val outboundPolicy: Output<DaprComponentResiliencyPolicyConfigurationResponse>?
        get() = javaResource.outboundPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    daprComponentResiliencyPolicyConfigurationResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DaprComponentResiliencyPolicyMapper : ResourceMapper<DaprComponentResiliencyPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.app.DaprComponentResiliencyPolicy::class == javaResource::class

    override fun map(javaResource: Resource): DaprComponentResiliencyPolicy =
        DaprComponentResiliencyPolicy(
            javaResource as
                com.pulumi.azurenative.app.DaprComponentResiliencyPolicy,
        )
}

/**
 * @see [DaprComponentResiliencyPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DaprComponentResiliencyPolicy].
 */
public suspend fun daprComponentResiliencyPolicy(
    name: String,
    block: suspend DaprComponentResiliencyPolicyResourceBuilder.() -> Unit,
):
    DaprComponentResiliencyPolicy {
    val builder = DaprComponentResiliencyPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DaprComponentResiliencyPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun daprComponentResiliencyPolicy(name: String): DaprComponentResiliencyPolicy {
    val builder = DaprComponentResiliencyPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
