@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin

import com.pulumi.azurenative.app.DaprComponentResiliencyPolicyArgs.builder
import com.pulumi.azurenative.app.kotlin.inputs.DaprComponentResiliencyPolicyConfigurationArgs
import com.pulumi.azurenative.app.kotlin.inputs.DaprComponentResiliencyPolicyConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Dapr Component Resiliency Policy.
 * Azure REST API version: 2023-08-01-preview.
 * ## Example Usage
 * ### Create or update dapr component resiliency policy with all options
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var daprComponentResiliencyPolicy = new AzureNative.App.DaprComponentResiliencyPolicy("daprComponentResiliencyPolicy", new()
 *     {
 *         ComponentName = "mydaprcomponent",
 *         EnvironmentName = "myenvironment",
 *         InboundPolicy = new AzureNative.App.Inputs.DaprComponentResiliencyPolicyConfigurationArgs
 *         {
 *             HttpRetryPolicy = new AzureNative.App.Inputs.DaprComponentResiliencyPolicyHttpRetryPolicyConfigurationArgs
 *             {
 *                 MaxRetries = 15,
 *                 RetryBackOff = new AzureNative.App.Inputs.DaprComponentResiliencyPolicyHttpRetryBackOffConfigurationArgs
 *                 {
 *                     InitialDelayInMilliseconds = 2000,
 *                     MaxIntervalInMilliseconds = 5500,
 *                 },
 *             },
 *             TimeoutPolicy = new AzureNative.App.Inputs.DaprComponentResiliencyPolicyTimeoutPolicyConfigurationArgs
 *             {
 *                 ResponseTimeoutInSeconds = 30,
 *             },
 *         },
 *         Name = "myresiliencypolicy",
 *         OutboundPolicy = new AzureNative.App.Inputs.DaprComponentResiliencyPolicyConfigurationArgs
 *         {
 *             HttpRetryPolicy = new AzureNative.App.Inputs.DaprComponentResiliencyPolicyHttpRetryPolicyConfigurationArgs
 *             {
 *                 MaxRetries = 5,
 *                 RetryBackOff = new AzureNative.App.Inputs.DaprComponentResiliencyPolicyHttpRetryBackOffConfigurationArgs
 *                 {
 *                     InitialDelayInMilliseconds = 100,
 *                     MaxIntervalInMilliseconds = 30000,
 *                 },
 *             },
 *             TimeoutPolicy = new AzureNative.App.Inputs.DaprComponentResiliencyPolicyTimeoutPolicyConfigurationArgs
 *             {
 *                 ResponseTimeoutInSeconds = 12,
 *             },
 *         },
 *         ResourceGroupName = "examplerg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := app.NewDaprComponentResiliencyPolicy(ctx, "daprComponentResiliencyPolicy", &app.DaprComponentResiliencyPolicyArgs{
 * ComponentName: pulumi.String("mydaprcomponent"),
 * EnvironmentName: pulumi.String("myenvironment"),
 * InboundPolicy: app.DaprComponentResiliencyPolicyConfigurationResponse{
 * HttpRetryPolicy: interface{}{
 * MaxRetries: pulumi.Int(15),
 * RetryBackOff: &app.DaprComponentResiliencyPolicyHttpRetryBackOffConfigurationArgs{
 * InitialDelayInMilliseconds: pulumi.Int(2000),
 * MaxIntervalInMilliseconds: pulumi.Int(5500),
 * },
 * },
 * TimeoutPolicy: &app.DaprComponentResiliencyPolicyTimeoutPolicyConfigurationArgs{
 * ResponseTimeoutInSeconds: pulumi.Int(30),
 * },
 * },
 * Name: pulumi.String("myresiliencypolicy"),
 * OutboundPolicy: app.DaprComponentResiliencyPolicyConfigurationResponse{
 * HttpRetryPolicy: interface{}{
 * MaxRetries: pulumi.Int(5),
 * RetryBackOff: &app.DaprComponentResiliencyPolicyHttpRetryBackOffConfigurationArgs{
 * InitialDelayInMilliseconds: pulumi.Int(100),
 * MaxIntervalInMilliseconds: pulumi.Int(30000),
 * },
 * },
 * TimeoutPolicy: &app.DaprComponentResiliencyPolicyTimeoutPolicyConfigurationArgs{
 * ResponseTimeoutInSeconds: pulumi.Int(12),
 * },
 * },
 * ResourceGroupName: pulumi.String("examplerg"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.DaprComponentResiliencyPolicy;
 * import com.pulumi.azurenative.app.DaprComponentResiliencyPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var daprComponentResiliencyPolicy = new DaprComponentResiliencyPolicy("daprComponentResiliencyPolicy", DaprComponentResiliencyPolicyArgs.builder()
 *             .componentName("mydaprcomponent")
 *             .environmentName("myenvironment")
 *             .inboundPolicy(Map.ofEntries(
 *                 Map.entry("httpRetryPolicy", Map.ofEntries(
 *                     Map.entry("maxRetries", 15),
 *                     Map.entry("retryBackOff", Map.ofEntries(
 *                         Map.entry("initialDelayInMilliseconds", 2000),
 *                         Map.entry("maxIntervalInMilliseconds", 5500)
 *                     ))
 *                 )),
 *                 Map.entry("timeoutPolicy", Map.of("responseTimeoutInSeconds", 30))
 *             ))
 *             .name("myresiliencypolicy")
 *             .outboundPolicy(Map.ofEntries(
 *                 Map.entry("httpRetryPolicy", Map.ofEntries(
 *                     Map.entry("maxRetries", 5),
 *                     Map.entry("retryBackOff", Map.ofEntries(
 *                         Map.entry("initialDelayInMilliseconds", 100),
 *                         Map.entry("maxIntervalInMilliseconds", 30000)
 *                     ))
 *                 )),
 *                 Map.entry("timeoutPolicy", Map.of("responseTimeoutInSeconds", 12))
 *             ))
 *             .resourceGroupName("examplerg")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update dapr component resiliency policy with outbound policy only
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var daprComponentResiliencyPolicy = new AzureNative.App.DaprComponentResiliencyPolicy("daprComponentResiliencyPolicy", new()
 *     {
 *         ComponentName = "mydaprcomponent",
 *         EnvironmentName = "myenvironment",
 *         Name = "myresiliencypolicy",
 *         OutboundPolicy = new AzureNative.App.Inputs.DaprComponentResiliencyPolicyConfigurationArgs
 *         {
 *             HttpRetryPolicy = new AzureNative.App.Inputs.DaprComponentResiliencyPolicyHttpRetryPolicyConfigurationArgs
 *             {
 *                 MaxRetries = 5,
 *                 RetryBackOff = new AzureNative.App.Inputs.DaprComponentResiliencyPolicyHttpRetryBackOffConfigurationArgs
 *                 {
 *                     InitialDelayInMilliseconds = 100,
 *                     MaxIntervalInMilliseconds = 30000,
 *                 },
 *             },
 *             TimeoutPolicy = new AzureNative.App.Inputs.DaprComponentResiliencyPolicyTimeoutPolicyConfigurationArgs
 *             {
 *                 ResponseTimeoutInSeconds = 12,
 *             },
 *         },
 *         ResourceGroupName = "examplerg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := app.NewDaprComponentResiliencyPolicy(ctx, "daprComponentResiliencyPolicy", &app.DaprComponentResiliencyPolicyArgs{
 * ComponentName: pulumi.String("mydaprcomponent"),
 * EnvironmentName: pulumi.String("myenvironment"),
 * Name: pulumi.String("myresiliencypolicy"),
 * OutboundPolicy: app.DaprComponentResiliencyPolicyConfigurationResponse{
 * HttpRetryPolicy: interface{}{
 * MaxRetries: pulumi.Int(5),
 * RetryBackOff: &app.DaprComponentResiliencyPolicyHttpRetryBackOffConfigurationArgs{
 * InitialDelayInMilliseconds: pulumi.Int(100),
 * MaxIntervalInMilliseconds: pulumi.Int(30000),
 * },
 * },
 * TimeoutPolicy: &app.DaprComponentResiliencyPolicyTimeoutPolicyConfigurationArgs{
 * ResponseTimeoutInSeconds: pulumi.Int(12),
 * },
 * },
 * ResourceGroupName: pulumi.String("examplerg"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.DaprComponentResiliencyPolicy;
 * import com.pulumi.azurenative.app.DaprComponentResiliencyPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var daprComponentResiliencyPolicy = new DaprComponentResiliencyPolicy("daprComponentResiliencyPolicy", DaprComponentResiliencyPolicyArgs.builder()
 *             .componentName("mydaprcomponent")
 *             .environmentName("myenvironment")
 *             .name("myresiliencypolicy")
 *             .outboundPolicy(Map.ofEntries(
 *                 Map.entry("httpRetryPolicy", Map.ofEntries(
 *                     Map.entry("maxRetries", 5),
 *                     Map.entry("retryBackOff", Map.ofEntries(
 *                         Map.entry("initialDelayInMilliseconds", 100),
 *                         Map.entry("maxIntervalInMilliseconds", 30000)
 *                     ))
 *                 )),
 *                 Map.entry("timeoutPolicy", Map.of("responseTimeoutInSeconds", 12))
 *             ))
 *             .resourceGroupName("examplerg")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update dapr component resiliency policy with sparse options
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var daprComponentResiliencyPolicy = new AzureNative.App.DaprComponentResiliencyPolicy("daprComponentResiliencyPolicy", new()
 *     {
 *         ComponentName = "mydaprcomponent",
 *         EnvironmentName = "myenvironment",
 *         InboundPolicy = new AzureNative.App.Inputs.DaprComponentResiliencyPolicyConfigurationArgs
 *         {
 *             HttpRetryPolicy = new AzureNative.App.Inputs.DaprComponentResiliencyPolicyHttpRetryPolicyConfigurationArgs
 *             {
 *                 MaxRetries = 5,
 *                 RetryBackOff = new AzureNative.App.Inputs.DaprComponentResiliencyPolicyHttpRetryBackOffConfigurationArgs
 *                 {
 *                     InitialDelayInMilliseconds = 2000,
 *                     MaxIntervalInMilliseconds = 5500,
 *                 },
 *             },
 *         },
 *         Name = "myresiliencypolicy",
 *         OutboundPolicy = new AzureNative.App.Inputs.DaprComponentResiliencyPolicyConfigurationArgs
 *         {
 *             TimeoutPolicy = new AzureNative.App.Inputs.DaprComponentResiliencyPolicyTimeoutPolicyConfigurationArgs
 *             {
 *                 ResponseTimeoutInSeconds = 12,
 *             },
 *         },
 *         ResourceGroupName = "examplerg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := app.NewDaprComponentResiliencyPolicy(ctx, "daprComponentResiliencyPolicy", &app.DaprComponentResiliencyPolicyArgs{
 * ComponentName: pulumi.String("mydaprcomponent"),
 * EnvironmentName: pulumi.String("myenvironment"),
 * InboundPolicy: app.DaprComponentResiliencyPolicyConfigurationResponse{
 * HttpRetryPolicy: interface{}{
 * MaxRetries: pulumi.Int(5),
 * RetryBackOff: &app.DaprComponentResiliencyPolicyHttpRetryBackOffConfigurationArgs{
 * InitialDelayInMilliseconds: pulumi.Int(2000),
 * MaxIntervalInMilliseconds: pulumi.Int(5500),
 * },
 * },
 * },
 * Name: pulumi.String("myresiliencypolicy"),
 * OutboundPolicy: app.DaprComponentResiliencyPolicyConfigurationResponse{
 * TimeoutPolicy: &app.DaprComponentResiliencyPolicyTimeoutPolicyConfigurationArgs{
 * ResponseTimeoutInSeconds: pulumi.Int(12),
 * },
 * },
 * ResourceGroupName: pulumi.String("examplerg"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.DaprComponentResiliencyPolicy;
 * import com.pulumi.azurenative.app.DaprComponentResiliencyPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var daprComponentResiliencyPolicy = new DaprComponentResiliencyPolicy("daprComponentResiliencyPolicy", DaprComponentResiliencyPolicyArgs.builder()
 *             .componentName("mydaprcomponent")
 *             .environmentName("myenvironment")
 *             .inboundPolicy(Map.of("httpRetryPolicy", Map.ofEntries(
 *                 Map.entry("maxRetries", 5),
 *                 Map.entry("retryBackOff", Map.ofEntries(
 *                     Map.entry("initialDelayInMilliseconds", 2000),
 *                     Map.entry("maxIntervalInMilliseconds", 5500)
 *                 ))
 *             )))
 *             .name("myresiliencypolicy")
 *             .outboundPolicy(Map.of("timeoutPolicy", Map.of("responseTimeoutInSeconds", 12)))
 *             .resourceGroupName("examplerg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:app:DaprComponentResiliencyPolicy myresiliencypolicy /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/managedEnvironments/{environmentName}/daprComponents/{componentName}/resiliencyPolicies/{name}
 * ```
 * @property componentName Name of the Dapr Component.
 * @property environmentName Name of the Managed Environment.
 * @property inboundPolicy The optional inbound component resiliency policy configuration
 * @property name Name of the Dapr Component Resiliency Policy.
 * @property outboundPolicy The optional outbound component resiliency policy configuration
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class DaprComponentResiliencyPolicyArgs(
    public val componentName: Output<String>? = null,
    public val environmentName: Output<String>? = null,
    public val inboundPolicy: Output<DaprComponentResiliencyPolicyConfigurationArgs>? = null,
    public val name: Output<String>? = null,
    public val outboundPolicy: Output<DaprComponentResiliencyPolicyConfigurationArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.DaprComponentResiliencyPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.app.DaprComponentResiliencyPolicyArgs =
        com.pulumi.azurenative.app.DaprComponentResiliencyPolicyArgs.builder()
            .componentName(componentName?.applyValue({ args0 -> args0 }))
            .environmentName(environmentName?.applyValue({ args0 -> args0 }))
            .inboundPolicy(inboundPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .outboundPolicy(outboundPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DaprComponentResiliencyPolicyArgs].
 */
@PulumiTagMarker
public class DaprComponentResiliencyPolicyArgsBuilder internal constructor() {
    private var componentName: Output<String>? = null

    private var environmentName: Output<String>? = null

    private var inboundPolicy: Output<DaprComponentResiliencyPolicyConfigurationArgs>? = null

    private var name: Output<String>? = null

    private var outboundPolicy: Output<DaprComponentResiliencyPolicyConfigurationArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Name of the Dapr Component.
     */
    @JvmName("gllmmcbcqivhmguv")
    public suspend fun componentName(`value`: Output<String>) {
        this.componentName = value
    }

    /**
     * @param value Name of the Managed Environment.
     */
    @JvmName("ruqwjdnguxdacxux")
    public suspend fun environmentName(`value`: Output<String>) {
        this.environmentName = value
    }

    /**
     * @param value The optional inbound component resiliency policy configuration
     */
    @JvmName("dpqkrmccniyosydk")
    public suspend
    fun inboundPolicy(`value`: Output<DaprComponentResiliencyPolicyConfigurationArgs>) {
        this.inboundPolicy = value
    }

    /**
     * @param value Name of the Dapr Component Resiliency Policy.
     */
    @JvmName("swaqixorcrekqwmc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The optional outbound component resiliency policy configuration
     */
    @JvmName("dpcbixyfqfceyevx")
    public suspend
    fun outboundPolicy(`value`: Output<DaprComponentResiliencyPolicyConfigurationArgs>) {
        this.outboundPolicy = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lqopfmxaigchpros")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the Dapr Component.
     */
    @JvmName("flvykiboaxnmyxpa")
    public suspend fun componentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.componentName = mapped
    }

    /**
     * @param value Name of the Managed Environment.
     */
    @JvmName("guinkacpgdwfwywc")
    public suspend fun environmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentName = mapped
    }

    /**
     * @param value The optional inbound component resiliency policy configuration
     */
    @JvmName("qhjyuleotifpkyjh")
    public suspend fun inboundPolicy(`value`: DaprComponentResiliencyPolicyConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inboundPolicy = mapped
    }

    /**
     * @param argument The optional inbound component resiliency policy configuration
     */
    @JvmName("kxuaahxsiyissmlu")
    public suspend
    fun inboundPolicy(argument: suspend DaprComponentResiliencyPolicyConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = DaprComponentResiliencyPolicyConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.inboundPolicy = mapped
    }

    /**
     * @param value Name of the Dapr Component Resiliency Policy.
     */
    @JvmName("ugtbkufhutmjfrew")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The optional outbound component resiliency policy configuration
     */
    @JvmName("pvpcerympstyvmdy")
    public suspend fun outboundPolicy(`value`: DaprComponentResiliencyPolicyConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outboundPolicy = mapped
    }

    /**
     * @param argument The optional outbound component resiliency policy configuration
     */
    @JvmName("rbgvfxgxmksjrwcd")
    public suspend
    fun outboundPolicy(argument: suspend DaprComponentResiliencyPolicyConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = DaprComponentResiliencyPolicyConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.outboundPolicy = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sjvbsnjljteawruc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): DaprComponentResiliencyPolicyArgs = DaprComponentResiliencyPolicyArgs(
        componentName = componentName,
        environmentName = environmentName,
        inboundPolicy = inboundPolicy,
        name = name,
        outboundPolicy = outboundPolicy,
        resourceGroupName = resourceGroupName,
    )
}
