@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin

import com.pulumi.azurenative.app.JobArgs.builder
import com.pulumi.azurenative.app.kotlin.inputs.JobConfigurationArgs
import com.pulumi.azurenative.app.kotlin.inputs.JobConfigurationArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.JobTemplateArgs
import com.pulumi.azurenative.app.kotlin.inputs.JobTemplateArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.app.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Container App Job
 * Azure REST API version: 2023-04-01-preview.
 * Other available API versions: 2023-05-01, 2023-05-02-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Create or Update Container Apps Job
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var job = new AzureNative.App.Job("job", new()
 *     {
 *         Configuration = new AzureNative.App.Inputs.JobConfigurationArgs
 *         {
 *             ManualTriggerConfig = new AzureNative.App.Inputs.JobConfigurationManualTriggerConfigArgs
 *             {
 *                 Parallelism = 4,
 *                 ReplicaCompletionCount = 1,
 *             },
 *             ReplicaRetryLimit = 10,
 *             ReplicaTimeout = 10,
 *             TriggerType = "Manual",
 *         },
 *         EnvironmentId = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.App/managedEnvironments/demokube",
 *         JobName = "testcontainerAppsJob0",
 *         Location = "East US",
 *         ResourceGroupName = "rg",
 *         Template = new AzureNative.App.Inputs.JobTemplateArgs
 *         {
 *             Containers = new[]
 *             {
 *                 new AzureNative.App.Inputs.ContainerArgs
 *                 {
 *                     Image = "repo/testcontainerAppsJob0:v1",
 *                     Name = "testcontainerAppsJob0",
 *                     Probes = new[]
 *                     {
 *                         new AzureNative.App.Inputs.ContainerAppProbeArgs
 *                         {
 *                             HttpGet = new AzureNative.App.Inputs.ContainerAppProbeHttpGetArgs
 *                             {
 *                                 HttpHeaders = new[]
 *                                 {
 *                                     new AzureNative.App.Inputs.ContainerAppProbeHttpHeadersArgs
 *                                     {
 *                                         Name = "Custom-Header",
 *                                         Value = "Awesome",
 *                                     },
 *                                 },
 *                                 Path = "/health",
 *                                 Port = 8080,
 *                             },
 *                             InitialDelaySeconds = 5,
 *                             PeriodSeconds = 3,
 *                             Type = "Liveness",
 *                         },
 *                     },
 *                 },
 *             },
 *             InitContainers = new[]
 *             {
 *                 new AzureNative.App.Inputs.InitContainerArgs
 *                 {
 *                     Args = new[]
 *                     {
 *                         "-c",
 *                         "while true; do echo hello; sleep 10;done",
 *                     },
 *                     Command = new[]
 *                     {
 *                         "/bin/sh",
 *                     },
 *                     Image = "repo/testcontainerAppsJob0:v4",
 *                     Name = "testinitcontainerAppsJob0",
 *                     Resources = new AzureNative.App.Inputs.ContainerResourcesArgs
 *                     {
 *                         Cpu = 0.2,
 *                         Memory = "100Mi",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := app.NewJob(ctx, "job", &app.JobArgs{
 * Configuration: app.JobConfigurationResponse{
 * ManualTriggerConfig: &app.JobConfigurationManualTriggerConfigArgs{
 * Parallelism: pulumi.Int(4),
 * ReplicaCompletionCount: pulumi.Int(1),
 * },
 * ReplicaRetryLimit: pulumi.Int(10),
 * ReplicaTimeout: pulumi.Int(10),
 * TriggerType: pulumi.String("Manual"),
 * },
 * EnvironmentId: pulumi.String("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.App/managedEnvironments/demokube"),
 * JobName: pulumi.String("testcontainerAppsJob0"),
 * Location: pulumi.String("East US"),
 * ResourceGroupName: pulumi.String("rg"),
 * Template: app.JobTemplateResponse{
 * Containers: app.ContainerArray{
 * interface{}{
 * Image: pulumi.String("repo/testcontainerAppsJob0:v1"),
 * Name: pulumi.String("testcontainerAppsJob0"),
 * Probes: app.ContainerAppProbeArray{
 * interface{}{
 * HttpGet: interface{}{
 * HttpHeaders: app.ContainerAppProbeHttpHeadersArray{
 * &app.ContainerAppProbeHttpHeadersArgs{
 * Name: pulumi.String("Custom-Header"),
 * Value: pulumi.String("Awesome"),
 * },
 * },
 * Path: pulumi.String("/health"),
 * Port: pulumi.Int(8080),
 * },
 * InitialDelaySeconds: pulumi.Int(5),
 * PeriodSeconds: pulumi.Int(3),
 * Type: pulumi.String("Liveness"),
 * },
 * },
 * },
 * },
 * InitContainers: app.InitContainerArray{
 * interface{}{
 * Args: pulumi.StringArray{
 * pulumi.String("-c"),
 * pulumi.String("while true; do echo hello; sleep 10;done"),
 * },
 * Command: pulumi.StringArray{
 * pulumi.String("/bin/sh"),
 * },
 * Image: pulumi.String("repo/testcontainerAppsJob0:v4"),
 * Name: pulumi.String("testinitcontainerAppsJob0"),
 * Resources: &app.ContainerResourcesArgs{
 * Cpu: pulumi.Float64(0.2),
 * Memory: pulumi.String("100Mi"),
 * },
 * },
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.Job;
 * import com.pulumi.azurenative.app.JobArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var job = new Job("job", JobArgs.builder()
 *             .configuration(Map.ofEntries(
 *                 Map.entry("manualTriggerConfig", Map.ofEntries(
 *                     Map.entry("parallelism", 4),
 *                     Map.entry("replicaCompletionCount", 1)
 *                 )),
 *                 Map.entry("replicaRetryLimit", 10),
 *                 Map.entry("replicaTimeout", 10),
 *                 Map.entry("triggerType", "Manual")
 *             ))
 *             .environmentId("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.App/managedEnvironments/demokube")
 *             .jobName("testcontainerAppsJob0")
 *             .location("East US")
 *             .resourceGroupName("rg")
 *             .template(Map.ofEntries(
 *                 Map.entry("containers", Map.ofEntries(
 *                     Map.entry("image", "repo/testcontainerAppsJob0:v1"),
 *                     Map.entry("name", "testcontainerAppsJob0"),
 *                     Map.entry("probes", Map.ofEntries(
 *                         Map.entry("httpGet", Map.ofEntries(
 *                             Map.entry("httpHeaders", Map.ofEntries(
 *                                 Map.entry("name", "Custom-Header"),
 *                                 Map.entry("value", "Awesome")
 *                             )),
 *                             Map.entry("path", "/health"),
 *                             Map.entry("port", 8080)
 *                         )),
 *                         Map.entry("initialDelaySeconds", 5),
 *                         Map.entry("periodSeconds", 3),
 *                         Map.entry("type", "Liveness")
 *                     ))
 *                 )),
 *                 Map.entry("initContainers", Map.ofEntries(
 *                     Map.entry("args",
 *                         "-c",
 *                         "while true; do echo hello; sleep 10;done"),
 *                     Map.entry("command", "/bin/sh"),
 *                     Map.entry("image", "repo/testcontainerAppsJob0:v4"),
 *                     Map.entry("name", "testinitcontainerAppsJob0"),
 *                     Map.entry("resources", Map.ofEntries(
 *                         Map.entry("cpu", 0.2),
 *                         Map.entry("memory", "100Mi")
 *                     ))
 *                 ))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create or Update Container Apps Job With Event Driven Trigger
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var job = new AzureNative.App.Job("job", new()
 *     {
 *         Configuration = new AzureNative.App.Inputs.JobConfigurationArgs
 *         {
 *             EventTriggerConfig = new AzureNative.App.Inputs.JobConfigurationEventTriggerConfigArgs
 *             {
 *                 Parallelism = 4,
 *                 ReplicaCompletionCount = 1,
 *                 Scale = new AzureNative.App.Inputs.JobScaleArgs
 *                 {
 *                     MaxExecutions = 5,
 *                     MinExecutions = 1,
 *                     PollingInterval = 40,
 *                     Rules = new[]
 *                     {
 *                         new AzureNative.App.Inputs.JobScaleRuleArgs
 *                         {
 *                             Metadata =
 *                             {
 *                                 { "topicName", "my-topic" },
 *                             },
 *                             Name = "servicebuscalingrule",
 *                             Type = "azure-servicebus",
 *                         },
 *                     },
 *                 },
 *             },
 *             ReplicaRetryLimit = 10,
 *             ReplicaTimeout = 10,
 *             TriggerType = "Event",
 *         },
 *         EnvironmentId = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.App/managedEnvironments/demokube",
 *         JobName = "testcontainerAppsJob0",
 *         Location = "East US",
 *         ResourceGroupName = "rg",
 *         Template = new AzureNative.App.Inputs.JobTemplateArgs
 *         {
 *             Containers = new[]
 *             {
 *                 new AzureNative.App.Inputs.ContainerArgs
 *                 {
 *                     Image = "repo/testcontainerAppsJob0:v1",
 *                     Name = "testcontainerAppsJob0",
 *                 },
 *             },
 *             InitContainers = new[]
 *             {
 *                 new AzureNative.App.Inputs.InitContainerArgs
 *                 {
 *                     Args = new[]
 *                     {
 *                         "-c",
 *                         "while true; do echo hello; sleep 10;done",
 *                     },
 *                     Command = new[]
 *                     {
 *                         "/bin/sh",
 *                     },
 *                     Image = "repo/testcontainerAppsJob0:v4",
 *                     Name = "testinitcontainerAppsJob0",
 *                     Resources = new AzureNative.App.Inputs.ContainerResourcesArgs
 *                     {
 *                         Cpu = 0.2,
 *                         Memory = "100Mi",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := app.NewJob(ctx, "job", &app.JobArgs{
 * Configuration: app.JobConfigurationResponse{
 * EventTriggerConfig: interface{}{
 * Parallelism: pulumi.Int(4),
 * ReplicaCompletionCount: pulumi.Int(1),
 * Scale: interface{}{
 * MaxExecutions: pulumi.Int(5),
 * MinExecutions: pulumi.Int(1),
 * PollingInterval: pulumi.Int(40),
 * Rules: app.JobScaleRuleArray{
 * &app.JobScaleRuleArgs{
 * Metadata: pulumi.Any{
 * TopicName: "my-topic",
 * },
 * Name: pulumi.String("servicebuscalingrule"),
 * Type: pulumi.String("azure-servicebus"),
 * },
 * },
 * },
 * },
 * ReplicaRetryLimit: pulumi.Int(10),
 * ReplicaTimeout: pulumi.Int(10),
 * TriggerType: pulumi.String("Event"),
 * },
 * EnvironmentId: pulumi.String("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.App/managedEnvironments/demokube"),
 * JobName: pulumi.String("testcontainerAppsJob0"),
 * Location: pulumi.String("East US"),
 * ResourceGroupName: pulumi.String("rg"),
 * Template: app.JobTemplateResponse{
 * Containers: app.ContainerArray{
 * &app.ContainerArgs{
 * Image: pulumi.String("repo/testcontainerAppsJob0:v1"),
 * Name: pulumi.String("testcontainerAppsJob0"),
 * },
 * },
 * InitContainers: app.InitContainerArray{
 * interface{}{
 * Args: pulumi.StringArray{
 * pulumi.String("-c"),
 * pulumi.String("while true; do echo hello; sleep 10;done"),
 * },
 * Command: pulumi.StringArray{
 * pulumi.String("/bin/sh"),
 * },
 * Image: pulumi.String("repo/testcontainerAppsJob0:v4"),
 * Name: pulumi.String("testinitcontainerAppsJob0"),
 * Resources: &app.ContainerResourcesArgs{
 * Cpu: pulumi.Float64(0.2),
 * Memory: pulumi.String("100Mi"),
 * },
 * },
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.Job;
 * import com.pulumi.azurenative.app.JobArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var job = new Job("job", JobArgs.builder()
 *             .configuration(Map.ofEntries(
 *                 Map.entry("eventTriggerConfig", Map.ofEntries(
 *                     Map.entry("parallelism", 4),
 *                     Map.entry("replicaCompletionCount", 1),
 *                     Map.entry("scale", Map.ofEntries(
 *                         Map.entry("maxExecutions", 5),
 *                         Map.entry("minExecutions", 1),
 *                         Map.entry("pollingInterval", 40),
 *                         Map.entry("rules", Map.ofEntries(
 *                             Map.entry("metadata", Map.of("topicName", "my-topic")),
 *                             Map.entry("name", "servicebuscalingrule"),
 *                             Map.entry("type", "azure-servicebus")
 *                         ))
 *                     ))
 *                 )),
 *                 Map.entry("replicaRetryLimit", 10),
 *                 Map.entry("replicaTimeout", 10),
 *                 Map.entry("triggerType", "Event")
 *             ))
 *             .environmentId("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.App/managedEnvironments/demokube")
 *             .jobName("testcontainerAppsJob0")
 *             .location("East US")
 *             .resourceGroupName("rg")
 *             .template(Map.ofEntries(
 *                 Map.entry("containers", Map.ofEntries(
 *                     Map.entry("image", "repo/testcontainerAppsJob0:v1"),
 *                     Map.entry("name", "testcontainerAppsJob0")
 *                 )),
 *                 Map.entry("initContainers", Map.ofEntries(
 *                     Map.entry("args",
 *                         "-c",
 *                         "while true; do echo hello; sleep 10;done"),
 *                     Map.entry("command", "/bin/sh"),
 *                     Map.entry("image", "repo/testcontainerAppsJob0:v4"),
 *                     Map.entry("name", "testinitcontainerAppsJob0"),
 *                     Map.entry("resources", Map.ofEntries(
 *                         Map.entry("cpu", 0.2),
 *                         Map.entry("memory", "100Mi")
 *                     ))
 *                 ))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:app:Job testcontainerAppsJob0 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/jobs/{jobName}
 * ```
 * @property configuration Container Apps Job configuration properties.
 * @property environmentId Resource ID of environment.
 * @property identity Managed identities needed by a container app job to interact with other Azure services to not maintain any secrets or credentials in code.
 * @property jobName Job Name
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property template Container Apps job definition.
 * @property workloadProfileName Workload profile name to pin for container apps job execution.
 */
public data class JobArgs(
    public val configuration: Output<JobConfigurationArgs>? = null,
    public val environmentId: Output<String>? = null,
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val jobName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val template: Output<JobTemplateArgs>? = null,
    public val workloadProfileName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.JobArgs> {
    override fun toJava(): com.pulumi.azurenative.app.JobArgs =
        com.pulumi.azurenative.app.JobArgs.builder()
            .configuration(configuration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .environmentId(environmentId?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .jobName(jobName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .template(template?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .workloadProfileName(workloadProfileName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobArgs].
 */
@PulumiTagMarker
public class JobArgsBuilder internal constructor() {
    private var configuration: Output<JobConfigurationArgs>? = null

    private var environmentId: Output<String>? = null

    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var jobName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var template: Output<JobTemplateArgs>? = null

    private var workloadProfileName: Output<String>? = null

    /**
     * @param value Container Apps Job configuration properties.
     */
    @JvmName("rhboggdrvhpdmitk")
    public suspend fun configuration(`value`: Output<JobConfigurationArgs>) {
        this.configuration = value
    }

    /**
     * @param value Resource ID of environment.
     */
    @JvmName("eqrdmeugtacyieot")
    public suspend fun environmentId(`value`: Output<String>) {
        this.environmentId = value
    }

    /**
     * @param value Managed identities needed by a container app job to interact with other Azure services to not maintain any secrets or credentials in code.
     */
    @JvmName("obsjjmnammtfmsui")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Job Name
     */
    @JvmName("svjayuoadomnqabb")
    public suspend fun jobName(`value`: Output<String>) {
        this.jobName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("bdcmgifxjlbkygri")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qelspmkaecjpbpfp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("dckasbokpjppsynr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Container Apps job definition.
     */
    @JvmName("ljdsugfpabdyablt")
    public suspend fun template(`value`: Output<JobTemplateArgs>) {
        this.template = value
    }

    /**
     * @param value Workload profile name to pin for container apps job execution.
     */
    @JvmName("jwyuptyaljwfxlaw")
    public suspend fun workloadProfileName(`value`: Output<String>) {
        this.workloadProfileName = value
    }

    /**
     * @param value Container Apps Job configuration properties.
     */
    @JvmName("wcpqugpbclgilbla")
    public suspend fun configuration(`value`: JobConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param argument Container Apps Job configuration properties.
     */
    @JvmName("unchxfuftgqvejrg")
    public suspend fun configuration(argument: suspend JobConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = JobConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.configuration = mapped
    }

    /**
     * @param value Resource ID of environment.
     */
    @JvmName("yccmcshrqounbfil")
    public suspend fun environmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentId = mapped
    }

    /**
     * @param value Managed identities needed by a container app job to interact with other Azure services to not maintain any secrets or credentials in code.
     */
    @JvmName("tqjstrvmgkvmdgdx")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Managed identities needed by a container app job to interact with other Azure services to not maintain any secrets or credentials in code.
     */
    @JvmName("shipgcnhnlgbuntc")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Job Name
     */
    @JvmName("vngruqagctpflnrd")
    public suspend fun jobName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("dyukcgxflmnqxaqv")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bsjfihrfwblxoymj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ijffiujuerpomhuu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("cnerwwvdyptgiexc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Container Apps job definition.
     */
    @JvmName("hkijhlvbmobpnqjk")
    public suspend fun template(`value`: JobTemplateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.template = mapped
    }

    /**
     * @param argument Container Apps job definition.
     */
    @JvmName("cbcwugvjoooavvjr")
    public suspend fun template(argument: suspend JobTemplateArgsBuilder.() -> Unit) {
        val toBeMapped = JobTemplateArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.template = mapped
    }

    /**
     * @param value Workload profile name to pin for container apps job execution.
     */
    @JvmName("twscgqxffwvjhqsk")
    public suspend fun workloadProfileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workloadProfileName = mapped
    }

    internal fun build(): JobArgs = JobArgs(
        configuration = configuration,
        environmentId = environmentId,
        identity = identity,
        jobName = jobName,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
        template = template,
        workloadProfileName = workloadProfileName,
    )
}
