@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin

import com.pulumi.azurenative.app.kotlin.outputs.ManagedEnvironmentStorageResponseProperties
import com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.app.kotlin.outputs.ManagedEnvironmentStorageResponseProperties.Companion.toKotlin as managedEnvironmentStorageResponsePropertiesToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ManagedEnvironmentsStorage].
 */
@PulumiTagMarker
public class ManagedEnvironmentsStorageResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagedEnvironmentsStorageArgs = ManagedEnvironmentsStorageArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ManagedEnvironmentsStorageArgsBuilder.() -> Unit) {
        val builder = ManagedEnvironmentsStorageArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ManagedEnvironmentsStorage {
        val builtJavaResource =
            com.pulumi.azurenative.app.ManagedEnvironmentsStorage(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ManagedEnvironmentsStorage(builtJavaResource)
    }
}

/**
 * Storage resource for managedEnvironment.
 * Azure REST API version: 2022-10-01. Prior API version in Azure Native 1.x: 2022-03-01.
 * Other available API versions: 2022-01-01-preview, 2023-04-01-preview, 2023-05-01, 2023-05-02-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Create or update environments storage
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedEnvironmentsStorage = new AzureNative.App.ManagedEnvironmentsStorage("managedEnvironmentsStorage", new()
 *     {
 *         EnvironmentName = "managedEnv",
 *         Properties = new AzureNative.App.Inputs.ManagedEnvironmentStoragePropertiesArgs
 *         {
 *             AzureFile = new AzureNative.App.Inputs.AzureFilePropertiesArgs
 *             {
 *                 AccessMode = "ReadOnly",
 *                 AccountKey = "key",
 *                 AccountName = "account1",
 *                 ShareName = "share1",
 *             },
 *         },
 *         ResourceGroupName = "examplerg",
 *         StorageName = "jlaw-demo1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := app.NewManagedEnvironmentsStorage(ctx, "managedEnvironmentsStorage", &app.ManagedEnvironmentsStorageArgs{
 * 			EnvironmentName: pulumi.String("managedEnv"),
 * 			Properties: app.ManagedEnvironmentStorageResponseProperties{
 * 				AzureFile: &app.AzureFilePropertiesArgs{
 * 					AccessMode:  pulumi.String("ReadOnly"),
 * 					AccountKey:  pulumi.String("key"),
 * 					AccountName: pulumi.String("account1"),
 * 					ShareName:   pulumi.String("share1"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 			StorageName:       pulumi.String("jlaw-demo1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.ManagedEnvironmentsStorage;
 * import com.pulumi.azurenative.app.ManagedEnvironmentsStorageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedEnvironmentsStorage = new ManagedEnvironmentsStorage("managedEnvironmentsStorage", ManagedEnvironmentsStorageArgs.builder()
 *             .environmentName("managedEnv")
 *             .properties(Map.of("azureFile", Map.ofEntries(
 *                 Map.entry("accessMode", "ReadOnly"),
 *                 Map.entry("accountKey", "key"),
 *                 Map.entry("accountName", "account1"),
 *                 Map.entry("shareName", "share1")
 *             )))
 *             .resourceGroupName("examplerg")
 *             .storageName("jlaw-demo1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:app:ManagedEnvironmentsStorage jlaw-demo1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/managedEnvironments/{environmentName}/storages/{storageName}
 * ```
 */
public class ManagedEnvironmentsStorage internal constructor(
    override val javaResource: com.pulumi.azurenative.app.ManagedEnvironmentsStorage,
) : KotlinCustomResource(javaResource, ManagedEnvironmentsStorageMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Storage properties
     */
    public val properties: Output<ManagedEnvironmentStorageResponseProperties>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                managedEnvironmentStorageResponsePropertiesToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ManagedEnvironmentsStorageMapper : ResourceMapper<ManagedEnvironmentsStorage> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.app.ManagedEnvironmentsStorage::class == javaResource::class

    override fun map(javaResource: Resource): ManagedEnvironmentsStorage =
        ManagedEnvironmentsStorage(
            javaResource as
                com.pulumi.azurenative.app.ManagedEnvironmentsStorage,
        )
}

/**
 * @see [ManagedEnvironmentsStorage].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagedEnvironmentsStorage].
 */
public suspend fun managedEnvironmentsStorage(
    name: String,
    block: suspend ManagedEnvironmentsStorageResourceBuilder.() -> Unit,
):
    ManagedEnvironmentsStorage {
    val builder = ManagedEnvironmentsStorageResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagedEnvironmentsStorage].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managedEnvironmentsStorage(name: String): ManagedEnvironmentsStorage {
    val builder = ManagedEnvironmentsStorageResourceBuilder()
    builder.name(name)
    return builder.build()
}
