@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin

import com.pulumi.azurenative.app.ManagedEnvironmentsStorageArgs.builder
import com.pulumi.azurenative.app.kotlin.inputs.ManagedEnvironmentStoragePropertiesArgs
import com.pulumi.azurenative.app.kotlin.inputs.ManagedEnvironmentStoragePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Storage resource for managedEnvironment.
 * Azure REST API version: 2022-10-01. Prior API version in Azure Native 1.x: 2022-03-01.
 * Other available API versions: 2022-01-01-preview, 2023-04-01-preview, 2023-05-01, 2023-05-02-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Create or update environments storage
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedEnvironmentsStorage = new AzureNative.App.ManagedEnvironmentsStorage("managedEnvironmentsStorage", new()
 *     {
 *         EnvironmentName = "managedEnv",
 *         Properties = new AzureNative.App.Inputs.ManagedEnvironmentStoragePropertiesArgs
 *         {
 *             AzureFile = new AzureNative.App.Inputs.AzureFilePropertiesArgs
 *             {
 *                 AccessMode = "ReadOnly",
 *                 AccountKey = "key",
 *                 AccountName = "account1",
 *                 ShareName = "share1",
 *             },
 *         },
 *         ResourceGroupName = "examplerg",
 *         StorageName = "jlaw-demo1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := app.NewManagedEnvironmentsStorage(ctx, "managedEnvironmentsStorage", &app.ManagedEnvironmentsStorageArgs{
 * 			EnvironmentName: pulumi.String("managedEnv"),
 * 			Properties: app.ManagedEnvironmentStorageResponseProperties{
 * 				AzureFile: &app.AzureFilePropertiesArgs{
 * 					AccessMode:  pulumi.String("ReadOnly"),
 * 					AccountKey:  pulumi.String("key"),
 * 					AccountName: pulumi.String("account1"),
 * 					ShareName:   pulumi.String("share1"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 			StorageName:       pulumi.String("jlaw-demo1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.ManagedEnvironmentsStorage;
 * import com.pulumi.azurenative.app.ManagedEnvironmentsStorageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedEnvironmentsStorage = new ManagedEnvironmentsStorage("managedEnvironmentsStorage", ManagedEnvironmentsStorageArgs.builder()
 *             .environmentName("managedEnv")
 *             .properties(Map.of("azureFile", Map.ofEntries(
 *                 Map.entry("accessMode", "ReadOnly"),
 *                 Map.entry("accountKey", "key"),
 *                 Map.entry("accountName", "account1"),
 *                 Map.entry("shareName", "share1")
 *             )))
 *             .resourceGroupName("examplerg")
 *             .storageName("jlaw-demo1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:app:ManagedEnvironmentsStorage jlaw-demo1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/managedEnvironments/{environmentName}/storages/{storageName}
 * ```
 * @property environmentName Name of the Environment.
 * @property properties Storage properties
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property storageName Name of the storage.
 */
public data class ManagedEnvironmentsStorageArgs(
    public val environmentName: Output<String>? = null,
    public val properties: Output<ManagedEnvironmentStoragePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val storageName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.ManagedEnvironmentsStorageArgs> {
    override fun toJava(): com.pulumi.azurenative.app.ManagedEnvironmentsStorageArgs =
        com.pulumi.azurenative.app.ManagedEnvironmentsStorageArgs.builder()
            .environmentName(environmentName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .storageName(storageName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedEnvironmentsStorageArgs].
 */
@PulumiTagMarker
public class ManagedEnvironmentsStorageArgsBuilder internal constructor() {
    private var environmentName: Output<String>? = null

    private var properties: Output<ManagedEnvironmentStoragePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var storageName: Output<String>? = null

    /**
     * @param value Name of the Environment.
     */
    @JvmName("npajdumepbeotwyt")
    public suspend fun environmentName(`value`: Output<String>) {
        this.environmentName = value
    }

    /**
     * @param value Storage properties
     */
    @JvmName("kxpuacvajdyhewlj")
    public suspend fun properties(`value`: Output<ManagedEnvironmentStoragePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ktjcrotksdkterxg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the storage.
     */
    @JvmName("ckvcqwafyhyjhouq")
    public suspend fun storageName(`value`: Output<String>) {
        this.storageName = value
    }

    /**
     * @param value Name of the Environment.
     */
    @JvmName("fcmfepsqtjocsthy")
    public suspend fun environmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentName = mapped
    }

    /**
     * @param value Storage properties
     */
    @JvmName("nhtoqrbrkekylvko")
    public suspend fun properties(`value`: ManagedEnvironmentStoragePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Storage properties
     */
    @JvmName("ckfjkeaaqdeilkcp")
    public suspend
    fun properties(argument: suspend ManagedEnvironmentStoragePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedEnvironmentStoragePropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ntahrpglxudywusr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the storage.
     */
    @JvmName("xaxxiuvgojeanlvk")
    public suspend fun storageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageName = mapped
    }

    internal fun build(): ManagedEnvironmentsStorageArgs = ManagedEnvironmentsStorageArgs(
        environmentName = environmentName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        storageName = storageName,
    )
}
