@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Allow or Deny rules to determine for incoming IP. Note: Rules can only consist of ALL Allow or ALL Deny
 */
public enum class Action(
    public val javaValue: com.pulumi.azurenative.app.enums.Action,
) : ConvertibleToJava<com.pulumi.azurenative.app.enums.Action> {
    Allow(com.pulumi.azurenative.app.enums.Action.Allow),
    Deny(com.pulumi.azurenative.app.enums.Action.Deny),
    ;

    override fun toJava(): com.pulumi.azurenative.app.enums.Action = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.enums.Action): Action =
            Action.values().first { it.javaValue == javaType }
    }
}
