@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Scheme to use for connecting to the host. Defaults to HTTP.
 */
public enum class Scheme(
    public val javaValue: com.pulumi.azurenative.app.enums.Scheme,
) : ConvertibleToJava<com.pulumi.azurenative.app.enums.Scheme> {
    HTTP(com.pulumi.azurenative.app.enums.Scheme.HTTP),
    HTTPS(com.pulumi.azurenative.app.enums.Scheme.HTTPS),
    ;

    override fun toJava(): com.pulumi.azurenative.app.enums.Scheme = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.enums.Scheme): Scheme =
            Scheme.values().first { it.javaValue == javaType }
    }
}
