@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Name of the Sku.
 */
public enum class SkuName(
    public val javaValue: com.pulumi.azurenative.app.enums.SkuName,
) : ConvertibleToJava<com.pulumi.azurenative.app.enums.SkuName> {
    /**
     * Consumption SKU of Managed Environment.
     */
    Consumption(com.pulumi.azurenative.app.enums.SkuName.Consumption),

    /**
     * Premium SKU of Managed Environment.
     */
    Premium(com.pulumi.azurenative.app.enums.SkuName.Premium),
    ;

    override fun toJava(): com.pulumi.azurenative.app.enums.SkuName = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.enums.SkuName): SkuName =
            SkuName.values().first { it.javaValue == javaType }
    }
}
