@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.AppleRegistrationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The configuration settings of the registration for the Apple provider
 * @property clientId The Client ID of the app used for login.
 * @property clientSecretSettingName The app setting name that contains the client secret.
 */
public data class AppleRegistrationArgs(
    public val clientId: Output<String>? = null,
    public val clientSecretSettingName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.AppleRegistrationArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.AppleRegistrationArgs =
        com.pulumi.azurenative.app.inputs.AppleRegistrationArgs.builder()
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .clientSecretSettingName(clientSecretSettingName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AppleRegistrationArgs].
 */
@PulumiTagMarker
public class AppleRegistrationArgsBuilder internal constructor() {
    private var clientId: Output<String>? = null

    private var clientSecretSettingName: Output<String>? = null

    /**
     * @param value The Client ID of the app used for login.
     */
    @JvmName("xrlybajmcdcjsfti")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value The app setting name that contains the client secret.
     */
    @JvmName("legemqnlqubximrm")
    public suspend fun clientSecretSettingName(`value`: Output<String>) {
        this.clientSecretSettingName = value
    }

    /**
     * @param value The Client ID of the app used for login.
     */
    @JvmName("tiacbtpwicrpmdmw")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value The app setting name that contains the client secret.
     */
    @JvmName("twxctigbukjoyvso")
    public suspend fun clientSecretSettingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientSecretSettingName = mapped
    }

    internal fun build(): AppleRegistrationArgs = AppleRegistrationArgs(
        clientId = clientId,
        clientSecretSettingName = clientSecretSettingName,
    )
}
