@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.AzureCredentialsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Container App credentials.
 * @property clientId Client Id.
 * @property clientSecret Client Secret.
 * @property subscriptionId Subscription Id.
 * @property tenantId Tenant Id.
 */
public data class AzureCredentialsArgs(
    public val clientId: Output<String>? = null,
    public val clientSecret: Output<String>? = null,
    public val subscriptionId: Output<String>? = null,
    public val tenantId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.AzureCredentialsArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.AzureCredentialsArgs =
        com.pulumi.azurenative.app.inputs.AzureCredentialsArgs.builder()
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .clientSecret(clientSecret?.applyValue({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureCredentialsArgs].
 */
@PulumiTagMarker
public class AzureCredentialsArgsBuilder internal constructor() {
    private var clientId: Output<String>? = null

    private var clientSecret: Output<String>? = null

    private var subscriptionId: Output<String>? = null

    private var tenantId: Output<String>? = null

    /**
     * @param value Client Id.
     */
    @JvmName("rtgffrvvmxmeuvtd")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value Client Secret.
     */
    @JvmName("mghxvlkwomllyqya")
    public suspend fun clientSecret(`value`: Output<String>) {
        this.clientSecret = value
    }

    /**
     * @param value Subscription Id.
     */
    @JvmName("scngcvwjeiwbmycm")
    public suspend fun subscriptionId(`value`: Output<String>) {
        this.subscriptionId = value
    }

    /**
     * @param value Tenant Id.
     */
    @JvmName("vgnpaalyelolqarm")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value Client Id.
     */
    @JvmName("kpmwiaoaghonjwfb")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value Client Secret.
     */
    @JvmName("lbcrqfveviwtmfqj")
    public suspend fun clientSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value Subscription Id.
     */
    @JvmName("kkbdgvvobjepsrta")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    /**
     * @param value Tenant Id.
     */
    @JvmName("ykogktllcfuvfmux")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): AzureCredentialsArgs = AzureCredentialsArgs(
        clientId = clientId,
        clientSecret = clientSecret,
        subscriptionId = subscriptionId,
        tenantId = tenantId,
    )
}
