@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.AzureFilePropertiesArgs.builder
import com.pulumi.azurenative.app.kotlin.enums.AccessMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Azure File Properties.
 * @property accessMode Access mode for storage
 * @property accountKey Storage account key for azure file.
 * @property accountName Storage account name for azure file.
 * @property shareName Azure file share name.
 */
public data class AzureFilePropertiesArgs(
    public val accessMode: Output<Either<String, AccessMode>>? = null,
    public val accountKey: Output<String>? = null,
    public val accountName: Output<String>? = null,
    public val shareName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.AzureFilePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.AzureFilePropertiesArgs =
        com.pulumi.azurenative.app.inputs.AzureFilePropertiesArgs.builder()
            .accessMode(
                accessMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .accountKey(accountKey?.applyValue({ args0 -> args0 }))
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .shareName(shareName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureFilePropertiesArgs].
 */
@PulumiTagMarker
public class AzureFilePropertiesArgsBuilder internal constructor() {
    private var accessMode: Output<Either<String, AccessMode>>? = null

    private var accountKey: Output<String>? = null

    private var accountName: Output<String>? = null

    private var shareName: Output<String>? = null

    /**
     * @param value Access mode for storage
     */
    @JvmName("judojsjsebwnsqqj")
    public suspend fun accessMode(`value`: Output<Either<String, AccessMode>>) {
        this.accessMode = value
    }

    /**
     * @param value Storage account key for azure file.
     */
    @JvmName("guxcrajylucosfph")
    public suspend fun accountKey(`value`: Output<String>) {
        this.accountKey = value
    }

    /**
     * @param value Storage account name for azure file.
     */
    @JvmName("yjjjvpnvgkbuomfl")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Azure file share name.
     */
    @JvmName("dppuqxtdmgbimvmy")
    public suspend fun shareName(`value`: Output<String>) {
        this.shareName = value
    }

    /**
     * @param value Access mode for storage
     */
    @JvmName("sjtpwaqahqrpfqqw")
    public suspend fun accessMode(`value`: Either<String, AccessMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessMode = mapped
    }

    /**
     * @param value Access mode for storage
     */
    @JvmName("pislodgymgwiobek")
    public fun accessMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AccessMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessMode = mapped
    }

    /**
     * @param value Access mode for storage
     */
    @JvmName("okbxamegqjehyfhe")
    public fun accessMode(`value`: AccessMode) {
        val toBeMapped = Either.ofRight<String, AccessMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessMode = mapped
    }

    /**
     * @param value Storage account key for azure file.
     */
    @JvmName("agnuhgvwippmwwcq")
    public suspend fun accountKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountKey = mapped
    }

    /**
     * @param value Storage account name for azure file.
     */
    @JvmName("mxnqybuciaqcxvqa")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Azure file share name.
     */
    @JvmName("gjyywltvplrfouau")
    public suspend fun shareName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shareName = mapped
    }

    internal fun build(): AzureFilePropertiesArgs = AzureFilePropertiesArgs(
        accessMode = accessMode,
        accountKey = accountKey,
        accountName = accountName,
        shareName = shareName,
    )
}
