@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.AzureStaticWebAppsRegistrationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The configuration settings of the registration for the Azure Static Web Apps provider
 * @property clientId The Client ID of the app used for login.
 */
public data class AzureStaticWebAppsRegistrationArgs(
    public val clientId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.AzureStaticWebAppsRegistrationArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.AzureStaticWebAppsRegistrationArgs =
        com.pulumi.azurenative.app.inputs.AzureStaticWebAppsRegistrationArgs.builder()
            .clientId(clientId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureStaticWebAppsRegistrationArgs].
 */
@PulumiTagMarker
public class AzureStaticWebAppsRegistrationArgsBuilder internal constructor() {
    private var clientId: Output<String>? = null

    /**
     * @param value The Client ID of the app used for login.
     */
    @JvmName("bacxothbgemublon")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value The Client ID of the app used for login.
     */
    @JvmName("skrgxqsjphkwcyrx")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    internal fun build(): AzureStaticWebAppsRegistrationArgs = AzureStaticWebAppsRegistrationArgs(
        clientId = clientId,
    )
}
