@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.ContainerRegistryWithCustomImageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Container registry that the final image will be uploaded to.
 * @property image Full name that the final image should be uploaded as, including both image name and tag.
 * @property server Login server of the container registry that the final image should be uploaded to. Builder resource needs to have this container registry defined along with an identity to use to access it.
 */
public data class ContainerRegistryWithCustomImageArgs(
    public val image: Output<String>? = null,
    public val server: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.ContainerRegistryWithCustomImageArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.ContainerRegistryWithCustomImageArgs =
        com.pulumi.azurenative.app.inputs.ContainerRegistryWithCustomImageArgs.builder()
            .image(image?.applyValue({ args0 -> args0 }))
            .server(server.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerRegistryWithCustomImageArgs].
 */
@PulumiTagMarker
public class ContainerRegistryWithCustomImageArgsBuilder internal constructor() {
    private var image: Output<String>? = null

    private var server: Output<String>? = null

    /**
     * @param value Full name that the final image should be uploaded as, including both image name and tag.
     */
    @JvmName("vehwcaspmowimpvc")
    public suspend fun image(`value`: Output<String>) {
        this.image = value
    }

    /**
     * @param value Login server of the container registry that the final image should be uploaded to. Builder resource needs to have this container registry defined along with an identity to use to access it.
     */
    @JvmName("grkqqsobfgnayrlq")
    public suspend fun server(`value`: Output<String>) {
        this.server = value
    }

    /**
     * @param value Full name that the final image should be uploaded as, including both image name and tag.
     */
    @JvmName("dhulmxdqlgluuhmx")
    public suspend fun image(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.image = mapped
    }

    /**
     * @param value Login server of the container registry that the final image should be uploaded to. Builder resource needs to have this container registry defined along with an identity to use to access it.
     */
    @JvmName("bldtdgbljqjrfjet")
    public suspend fun server(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.server = mapped
    }

    internal fun build(): ContainerRegistryWithCustomImageArgs = ContainerRegistryWithCustomImageArgs(
        image = image,
        server = server ?: throw PulumiNullFieldException("server"),
    )
}
