@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.CustomDomainArgs.builder
import com.pulumi.azurenative.app.kotlin.enums.BindingType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Custom Domain of a Container App
 * @property bindingType Custom Domain binding type.
 * @property certificateId Resource Id of the Certificate to be bound to this hostname.
 * @property name Hostname.
 */
public data class CustomDomainArgs(
    public val bindingType: Output<Either<String, BindingType>>? = null,
    public val certificateId: Output<String>? = null,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.CustomDomainArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.CustomDomainArgs =
        com.pulumi.azurenative.app.inputs.CustomDomainArgs.builder()
            .bindingType(
                bindingType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .certificateId(certificateId?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomDomainArgs].
 */
@PulumiTagMarker
public class CustomDomainArgsBuilder internal constructor() {
    private var bindingType: Output<Either<String, BindingType>>? = null

    private var certificateId: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Custom Domain binding type.
     */
    @JvmName("amjacxjknelpsmki")
    public suspend fun bindingType(`value`: Output<Either<String, BindingType>>) {
        this.bindingType = value
    }

    /**
     * @param value Resource Id of the Certificate to be bound to this hostname.
     */
    @JvmName("klndqesfexjouhqg")
    public suspend fun certificateId(`value`: Output<String>) {
        this.certificateId = value
    }

    /**
     * @param value Hostname.
     */
    @JvmName("qkwiqifkewhhrnya")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Custom Domain binding type.
     */
    @JvmName("qpdimbdfsjinsqgh")
    public suspend fun bindingType(`value`: Either<String, BindingType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bindingType = mapped
    }

    /**
     * @param value Custom Domain binding type.
     */
    @JvmName("ueivtjcjckiioisq")
    public fun bindingType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BindingType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bindingType = mapped
    }

    /**
     * @param value Custom Domain binding type.
     */
    @JvmName("goyajcivjpfflrwv")
    public fun bindingType(`value`: BindingType) {
        val toBeMapped = Either.ofRight<String, BindingType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bindingType = mapped
    }

    /**
     * @param value Resource Id of the Certificate to be bound to this hostname.
     */
    @JvmName("bonebnmjjrlmgisv")
    public suspend fun certificateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateId = mapped
    }

    /**
     * @param value Hostname.
     */
    @JvmName("gbykvyxoelwfjqnj")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): CustomDomainArgs = CustomDomainArgs(
        bindingType = bindingType,
        certificateId = certificateId,
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
