@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.DaprComponentResiliencyPolicyConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Dapr Component Resiliency Policy Configuration.
 * @property httpRetryPolicy The optional HTTP retry policy configuration
 * @property timeoutPolicy The optional timeout policy configuration
 */
public data class DaprComponentResiliencyPolicyConfigurationArgs(
    public val httpRetryPolicy: Output<DaprComponentResiliencyPolicyHttpRetryPolicyConfigurationArgs>? =
        null,
    public val timeoutPolicy: Output<DaprComponentResiliencyPolicyTimeoutPolicyConfigurationArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.azurenative.app.inputs.DaprComponentResiliencyPolicyConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.app.inputs.DaprComponentResiliencyPolicyConfigurationArgs =
        com.pulumi.azurenative.app.inputs.DaprComponentResiliencyPolicyConfigurationArgs.builder()
            .httpRetryPolicy(httpRetryPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .timeoutPolicy(timeoutPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DaprComponentResiliencyPolicyConfigurationArgs].
 */
@PulumiTagMarker
public class DaprComponentResiliencyPolicyConfigurationArgsBuilder internal constructor() {
    private var httpRetryPolicy:
        Output<DaprComponentResiliencyPolicyHttpRetryPolicyConfigurationArgs>? = null

    private var timeoutPolicy: Output<DaprComponentResiliencyPolicyTimeoutPolicyConfigurationArgs>? =
        null

    /**
     * @param value The optional HTTP retry policy configuration
     */
    @JvmName("kaxbinvumqagtlrx")
    public suspend
    fun httpRetryPolicy(`value`: Output<DaprComponentResiliencyPolicyHttpRetryPolicyConfigurationArgs>) {
        this.httpRetryPolicy = value
    }

    /**
     * @param value The optional timeout policy configuration
     */
    @JvmName("mlycmfogxokmcfcy")
    public suspend
    fun timeoutPolicy(`value`: Output<DaprComponentResiliencyPolicyTimeoutPolicyConfigurationArgs>) {
        this.timeoutPolicy = value
    }

    /**
     * @param value The optional HTTP retry policy configuration
     */
    @JvmName("dxibeqpvoklgtqcm")
    public suspend
    fun httpRetryPolicy(`value`: DaprComponentResiliencyPolicyHttpRetryPolicyConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpRetryPolicy = mapped
    }

    /**
     * @param argument The optional HTTP retry policy configuration
     */
    @JvmName("rhlxlqunlgkyatwa")
    public suspend
    fun httpRetryPolicy(argument: suspend DaprComponentResiliencyPolicyHttpRetryPolicyConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            DaprComponentResiliencyPolicyHttpRetryPolicyConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.httpRetryPolicy = mapped
    }

    /**
     * @param value The optional timeout policy configuration
     */
    @JvmName("auvlxwcvyvisjgar")
    public suspend
    fun timeoutPolicy(`value`: DaprComponentResiliencyPolicyTimeoutPolicyConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutPolicy = mapped
    }

    /**
     * @param argument The optional timeout policy configuration
     */
    @JvmName("yvsejyqckmoygvvh")
    public suspend
    fun timeoutPolicy(argument: suspend DaprComponentResiliencyPolicyTimeoutPolicyConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            DaprComponentResiliencyPolicyTimeoutPolicyConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.timeoutPolicy = mapped
    }

    internal fun build(): DaprComponentResiliencyPolicyConfigurationArgs =
        DaprComponentResiliencyPolicyConfigurationArgs(
            httpRetryPolicy = httpRetryPolicy,
            timeoutPolicy = timeoutPolicy,
        )
}
