@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.DaprComponentResiliencyPolicyHttpRetryBackOffConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Dapr Component Resiliency Policy HTTP Retry Backoff Configuration.
 * @property initialDelayInMilliseconds The optional initial delay in milliseconds before an operation is retried
 * @property maxIntervalInMilliseconds The optional maximum time interval in milliseconds between retry attempts
 */
public data class DaprComponentResiliencyPolicyHttpRetryBackOffConfigurationArgs(
    public val initialDelayInMilliseconds: Output<Int>? = null,
    public val maxIntervalInMilliseconds: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.app.inputs.DaprComponentResiliencyPolicyHttpRetryBackOffConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.app.inputs.DaprComponentResiliencyPolicyHttpRetryBackOffConfigurationArgs =
        com.pulumi.azurenative.app.inputs.DaprComponentResiliencyPolicyHttpRetryBackOffConfigurationArgs.builder()
            .initialDelayInMilliseconds(initialDelayInMilliseconds?.applyValue({ args0 -> args0 }))
            .maxIntervalInMilliseconds(maxIntervalInMilliseconds?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DaprComponentResiliencyPolicyHttpRetryBackOffConfigurationArgs].
 */
@PulumiTagMarker
public class DaprComponentResiliencyPolicyHttpRetryBackOffConfigurationArgsBuilder internal
constructor() {
    private var initialDelayInMilliseconds: Output<Int>? = null

    private var maxIntervalInMilliseconds: Output<Int>? = null

    /**
     * @param value The optional initial delay in milliseconds before an operation is retried
     */
    @JvmName("dpxopqyhhvqccvpp")
    public suspend fun initialDelayInMilliseconds(`value`: Output<Int>) {
        this.initialDelayInMilliseconds = value
    }

    /**
     * @param value The optional maximum time interval in milliseconds between retry attempts
     */
    @JvmName("sxkkviyjjsqwglei")
    public suspend fun maxIntervalInMilliseconds(`value`: Output<Int>) {
        this.maxIntervalInMilliseconds = value
    }

    /**
     * @param value The optional initial delay in milliseconds before an operation is retried
     */
    @JvmName("hoiqfqguidnfcear")
    public suspend fun initialDelayInMilliseconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initialDelayInMilliseconds = mapped
    }

    /**
     * @param value The optional maximum time interval in milliseconds between retry attempts
     */
    @JvmName("xuynirvsqooavwhj")
    public suspend fun maxIntervalInMilliseconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxIntervalInMilliseconds = mapped
    }

    internal fun build(): DaprComponentResiliencyPolicyHttpRetryBackOffConfigurationArgs =
        DaprComponentResiliencyPolicyHttpRetryBackOffConfigurationArgs(
            initialDelayInMilliseconds = initialDelayInMilliseconds,
            maxIntervalInMilliseconds = maxIntervalInMilliseconds,
        )
}
