@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.DaprComponentResiliencyPolicyHttpRetryPolicyConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Dapr Component Resiliency Policy HTTP Retry Policy Configuration.
 * @property maxRetries The optional maximum number of retries
 * @property retryBackOff The optional retry backoff configuration
 */
public data class DaprComponentResiliencyPolicyHttpRetryPolicyConfigurationArgs(
    public val maxRetries: Output<Int>? = null,
    public val retryBackOff: Output<DaprComponentResiliencyPolicyHttpRetryBackOffConfigurationArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.azurenative.app.inputs.DaprComponentResiliencyPolicyHttpRetryPolicyConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.app.inputs.DaprComponentResiliencyPolicyHttpRetryPolicyConfigurationArgs =
        com.pulumi.azurenative.app.inputs.DaprComponentResiliencyPolicyHttpRetryPolicyConfigurationArgs.builder()
            .maxRetries(maxRetries?.applyValue({ args0 -> args0 }))
            .retryBackOff(retryBackOff?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DaprComponentResiliencyPolicyHttpRetryPolicyConfigurationArgs].
 */
@PulumiTagMarker
public class DaprComponentResiliencyPolicyHttpRetryPolicyConfigurationArgsBuilder internal
constructor() {
    private var maxRetries: Output<Int>? = null

    private var retryBackOff: Output<DaprComponentResiliencyPolicyHttpRetryBackOffConfigurationArgs>? =
        null

    /**
     * @param value The optional maximum number of retries
     */
    @JvmName("jwastfysqcmsvvsv")
    public suspend fun maxRetries(`value`: Output<Int>) {
        this.maxRetries = value
    }

    /**
     * @param value The optional retry backoff configuration
     */
    @JvmName("byvopfcuowlpfqbo")
    public suspend
    fun retryBackOff(`value`: Output<DaprComponentResiliencyPolicyHttpRetryBackOffConfigurationArgs>) {
        this.retryBackOff = value
    }

    /**
     * @param value The optional maximum number of retries
     */
    @JvmName("plrxjnunatowxbvv")
    public suspend fun maxRetries(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxRetries = mapped
    }

    /**
     * @param value The optional retry backoff configuration
     */
    @JvmName("vuaavwyopsbduhkd")
    public suspend
    fun retryBackOff(`value`: DaprComponentResiliencyPolicyHttpRetryBackOffConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retryBackOff = mapped
    }

    /**
     * @param argument The optional retry backoff configuration
     */
    @JvmName("cvnikcbixeoyyquh")
    public suspend
    fun retryBackOff(argument: suspend DaprComponentResiliencyPolicyHttpRetryBackOffConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            DaprComponentResiliencyPolicyHttpRetryBackOffConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.retryBackOff = mapped
    }

    internal fun build(): DaprComponentResiliencyPolicyHttpRetryPolicyConfigurationArgs =
        DaprComponentResiliencyPolicyHttpRetryPolicyConfigurationArgs(
            maxRetries = maxRetries,
            retryBackOff = retryBackOff,
        )
}
