@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.DaprSubscriptionRoutesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Dapr PubSub Event Subscription Routes configuration.
 * @property default The default path to deliver events that do not match any of the rules.
 * @property rules The list of Dapr PubSub Event Subscription Route Rules.
 */
public data class DaprSubscriptionRoutesArgs(
    public val default: Output<String>? = null,
    public val rules: Output<List<DaprSubscriptionRouteRuleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.DaprSubscriptionRoutesArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.DaprSubscriptionRoutesArgs =
        com.pulumi.azurenative.app.inputs.DaprSubscriptionRoutesArgs.builder()
            .default_(default?.applyValue({ args0 -> args0 }))
            .rules(
                rules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [DaprSubscriptionRoutesArgs].
 */
@PulumiTagMarker
public class DaprSubscriptionRoutesArgsBuilder internal constructor() {
    private var default: Output<String>? = null

    private var rules: Output<List<DaprSubscriptionRouteRuleArgs>>? = null

    /**
     * @param value The default path to deliver events that do not match any of the rules.
     */
    @JvmName("apktlsuntnjfwwea")
    public suspend fun default(`value`: Output<String>) {
        this.default = value
    }

    /**
     * @param value The list of Dapr PubSub Event Subscription Route Rules.
     */
    @JvmName("ryyilvfdryuyhadw")
    public suspend fun rules(`value`: Output<List<DaprSubscriptionRouteRuleArgs>>) {
        this.rules = value
    }

    @JvmName("yrhtluagxnvcvqji")
    public suspend fun rules(vararg values: Output<DaprSubscriptionRouteRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values The list of Dapr PubSub Event Subscription Route Rules.
     */
    @JvmName("jveiqceiekhwgndi")
    public suspend fun rules(values: List<Output<DaprSubscriptionRouteRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value The default path to deliver events that do not match any of the rules.
     */
    @JvmName("hbedvfcbaxysdgha")
    public suspend fun default(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.default = mapped
    }

    /**
     * @param value The list of Dapr PubSub Event Subscription Route Rules.
     */
    @JvmName("vhenoajnqshhuhbr")
    public suspend fun rules(`value`: List<DaprSubscriptionRouteRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument The list of Dapr PubSub Event Subscription Route Rules.
     */
    @JvmName("xxheghlguvaamwxk")
    public suspend
    fun rules(argument: List<suspend DaprSubscriptionRouteRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DaprSubscriptionRouteRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument The list of Dapr PubSub Event Subscription Route Rules.
     */
    @JvmName("sbminghwfpcawdqn")
    public suspend fun rules(
        vararg
        argument: suspend DaprSubscriptionRouteRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DaprSubscriptionRouteRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument The list of Dapr PubSub Event Subscription Route Rules.
     */
    @JvmName("vijpkhtuimpuetip")
    public suspend fun rules(argument: suspend DaprSubscriptionRouteRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DaprSubscriptionRouteRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values The list of Dapr PubSub Event Subscription Route Rules.
     */
    @JvmName("jaxyupcdnbgpbrwm")
    public suspend fun rules(vararg values: DaprSubscriptionRouteRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    internal fun build(): DaprSubscriptionRoutesArgs = DaprSubscriptionRoutesArgs(
        default = default,
        rules = rules,
    )
}
