@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.GetCertificatePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property certificateName Name of the Certificate.
 * @property environmentName Name of the Managed Environment.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetCertificatePlainArgs(
    public val certificateName: String,
    public val environmentName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.GetCertificatePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.GetCertificatePlainArgs =
        com.pulumi.azurenative.app.inputs.GetCertificatePlainArgs.builder()
            .certificateName(certificateName.let({ args0 -> args0 }))
            .environmentName(environmentName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCertificatePlainArgs].
 */
@PulumiTagMarker
public class GetCertificatePlainArgsBuilder internal constructor() {
    private var certificateName: String? = null

    private var environmentName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the Certificate.
     */
    @JvmName("xfyfqetatlrxmuqe")
    public suspend fun certificateName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.certificateName = mapped
    }

    /**
     * @param value Name of the Managed Environment.
     */
    @JvmName("quertjieqardiuim")
    public suspend fun environmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.environmentName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jodakllnlgpgdrgn")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetCertificatePlainArgs = GetCertificatePlainArgs(
        certificateName = certificateName ?: throw PulumiNullFieldException("certificateName"),
        environmentName = environmentName ?: throw PulumiNullFieldException("environmentName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
