@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.GetConnectedEnvironmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property connectedEnvironmentName Name of the connectedEnvironment.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetConnectedEnvironmentPlainArgs(
    public val connectedEnvironmentName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.GetConnectedEnvironmentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.GetConnectedEnvironmentPlainArgs =
        com.pulumi.azurenative.app.inputs.GetConnectedEnvironmentPlainArgs.builder()
            .connectedEnvironmentName(connectedEnvironmentName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConnectedEnvironmentPlainArgs].
 */
@PulumiTagMarker
public class GetConnectedEnvironmentPlainArgsBuilder internal constructor() {
    private var connectedEnvironmentName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the connectedEnvironment.
     */
    @JvmName("hspwyuobydmiqakj")
    public suspend fun connectedEnvironmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.connectedEnvironmentName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kpaqnkyolaqjucvy")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetConnectedEnvironmentPlainArgs = GetConnectedEnvironmentPlainArgs(
        connectedEnvironmentName = connectedEnvironmentName ?: throw
            PulumiNullFieldException("connectedEnvironmentName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
