@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.GetContainerAppAuthTokenPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property containerAppName Name of the Container App.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetContainerAppAuthTokenPlainArgs(
    public val containerAppName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.GetContainerAppAuthTokenPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.GetContainerAppAuthTokenPlainArgs =
        com.pulumi.azurenative.app.inputs.GetContainerAppAuthTokenPlainArgs.builder()
            .containerAppName(containerAppName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetContainerAppAuthTokenPlainArgs].
 */
@PulumiTagMarker
public class GetContainerAppAuthTokenPlainArgsBuilder internal constructor() {
    private var containerAppName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the Container App.
     */
    @JvmName("oiganrqmffggwawu")
    public suspend fun containerAppName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.containerAppName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lckqokjfmkiuhfqn")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetContainerAppAuthTokenPlainArgs = GetContainerAppAuthTokenPlainArgs(
        containerAppName = containerAppName ?: throw PulumiNullFieldException("containerAppName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
