@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.GetManagedEnvironmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property environmentName Name of the Environment.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetManagedEnvironmentPlainArgs(
    public val environmentName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.GetManagedEnvironmentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.GetManagedEnvironmentPlainArgs =
        com.pulumi.azurenative.app.inputs.GetManagedEnvironmentPlainArgs.builder()
            .environmentName(environmentName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagedEnvironmentPlainArgs].
 */
@PulumiTagMarker
public class GetManagedEnvironmentPlainArgsBuilder internal constructor() {
    private var environmentName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the Environment.
     */
    @JvmName("kaviykkfkjdepxoe")
    public suspend fun environmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.environmentName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xsmiweplublnsgxe")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetManagedEnvironmentPlainArgs = GetManagedEnvironmentPlainArgs(
        environmentName = environmentName ?: throw PulumiNullFieldException("environmentName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
