@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.HttpGetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Model representing a http get request.
 * @property fileName Name of the file that the request should be saved to.
 * @property headers List of headers to send with the request.
 * @property url URL to make HTTP GET request against.
 */
public data class HttpGetArgs(
    public val fileName: Output<String>? = null,
    public val headers: Output<List<String>>? = null,
    public val url: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.HttpGetArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.HttpGetArgs =
        com.pulumi.azurenative.app.inputs.HttpGetArgs.builder()
            .fileName(fileName?.applyValue({ args0 -> args0 }))
            .headers(headers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .url(url.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HttpGetArgs].
 */
@PulumiTagMarker
public class HttpGetArgsBuilder internal constructor() {
    private var fileName: Output<String>? = null

    private var headers: Output<List<String>>? = null

    private var url: Output<String>? = null

    /**
     * @param value Name of the file that the request should be saved to.
     */
    @JvmName("yfmuxassmkqqaqie")
    public suspend fun fileName(`value`: Output<String>) {
        this.fileName = value
    }

    /**
     * @param value List of headers to send with the request.
     */
    @JvmName("getmpqyrauyqcrfa")
    public suspend fun headers(`value`: Output<List<String>>) {
        this.headers = value
    }

    @JvmName("amgowhlyeiqmjtqu")
    public suspend fun headers(vararg values: Output<String>) {
        this.headers = Output.all(values.asList())
    }

    /**
     * @param values List of headers to send with the request.
     */
    @JvmName("msikpdnkojppxwlc")
    public suspend fun headers(values: List<Output<String>>) {
        this.headers = Output.all(values)
    }

    /**
     * @param value URL to make HTTP GET request against.
     */
    @JvmName("jdudpcnoropblbtk")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value Name of the file that the request should be saved to.
     */
    @JvmName("qicclataysjbivca")
    public suspend fun fileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileName = mapped
    }

    /**
     * @param value List of headers to send with the request.
     */
    @JvmName("xbtkeihvengpshfd")
    public suspend fun headers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param values List of headers to send with the request.
     */
    @JvmName("nwiwcwdvtinblqfl")
    public suspend fun headers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param value URL to make HTTP GET request against.
     */
    @JvmName("fqebxnpkjccevbtg")
    public suspend fun url(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.url = mapped
    }

    internal fun build(): HttpGetArgs = HttpGetArgs(
        fileName = fileName,
        headers = headers,
        url = url ?: throw PulumiNullFieldException("url"),
    )
}
