@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.JobConfigurationArgs.builder
import com.pulumi.azurenative.app.kotlin.enums.TriggerType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Non versioned Container Apps Job configuration properties
 * @property eventTriggerConfig Trigger configuration of an event driven job.
 * @property manualTriggerConfig Manual trigger configuration for a single execution job. Properties replicaCompletionCount and parallelism would be set to 1 by default
 * @property registries Collection of private container registry credentials used by a Container apps job
 * @property replicaRetryLimit Maximum number of retries before failing the job.
 * @property replicaTimeout Maximum number of seconds a replica is allowed to run.
 * @property scheduleTriggerConfig Cron formatted repeating trigger schedule ("* * * * *") for cronjobs. Properties completions and parallelism would be set to 1 by default
 * @property secrets Collection of secrets used by a Container Apps Job
 * @property triggerType Trigger type of the job
 */
public data class JobConfigurationArgs(
    public val eventTriggerConfig: Output<JobConfigurationEventTriggerConfigArgs>? = null,
    public val manualTriggerConfig: Output<JobConfigurationManualTriggerConfigArgs>? = null,
    public val registries: Output<List<RegistryCredentialsArgs>>? = null,
    public val replicaRetryLimit: Output<Int>? = null,
    public val replicaTimeout: Output<Int>,
    public val scheduleTriggerConfig: Output<JobConfigurationScheduleTriggerConfigArgs>? = null,
    public val secrets: Output<List<SecretArgs>>? = null,
    public val triggerType: Output<Either<String, TriggerType>>,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.JobConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.JobConfigurationArgs =
        com.pulumi.azurenative.app.inputs.JobConfigurationArgs.builder()
            .eventTriggerConfig(
                eventTriggerConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .manualTriggerConfig(
                manualTriggerConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .registries(
                registries?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .replicaRetryLimit(replicaRetryLimit?.applyValue({ args0 -> args0 }))
            .replicaTimeout(replicaTimeout.applyValue({ args0 -> args0 }))
            .scheduleTriggerConfig(
                scheduleTriggerConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .secrets(
                secrets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .triggerType(
                triggerType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [JobConfigurationArgs].
 */
@PulumiTagMarker
public class JobConfigurationArgsBuilder internal constructor() {
    private var eventTriggerConfig: Output<JobConfigurationEventTriggerConfigArgs>? = null

    private var manualTriggerConfig: Output<JobConfigurationManualTriggerConfigArgs>? = null

    private var registries: Output<List<RegistryCredentialsArgs>>? = null

    private var replicaRetryLimit: Output<Int>? = null

    private var replicaTimeout: Output<Int>? = null

    private var scheduleTriggerConfig: Output<JobConfigurationScheduleTriggerConfigArgs>? = null

    private var secrets: Output<List<SecretArgs>>? = null

    private var triggerType: Output<Either<String, TriggerType>>? = null

    /**
     * @param value Trigger configuration of an event driven job.
     */
    @JvmName("gclausqqsstedlnq")
    public suspend fun eventTriggerConfig(`value`: Output<JobConfigurationEventTriggerConfigArgs>) {
        this.eventTriggerConfig = value
    }

    /**
     * @param value Manual trigger configuration for a single execution job. Properties replicaCompletionCount and parallelism would be set to 1 by default
     */
    @JvmName("uomkqcyihiiveohk")
    public suspend fun manualTriggerConfig(`value`: Output<JobConfigurationManualTriggerConfigArgs>) {
        this.manualTriggerConfig = value
    }

    /**
     * @param value Collection of private container registry credentials used by a Container apps job
     */
    @JvmName("rivbykeycvvkcdac")
    public suspend fun registries(`value`: Output<List<RegistryCredentialsArgs>>) {
        this.registries = value
    }

    @JvmName("rkhkboosnedgntuk")
    public suspend fun registries(vararg values: Output<RegistryCredentialsArgs>) {
        this.registries = Output.all(values.asList())
    }

    /**
     * @param values Collection of private container registry credentials used by a Container apps job
     */
    @JvmName("mlnvokqpdnhwjxfo")
    public suspend fun registries(values: List<Output<RegistryCredentialsArgs>>) {
        this.registries = Output.all(values)
    }

    /**
     * @param value Maximum number of retries before failing the job.
     */
    @JvmName("rlmosslqevlkcvyh")
    public suspend fun replicaRetryLimit(`value`: Output<Int>) {
        this.replicaRetryLimit = value
    }

    /**
     * @param value Maximum number of seconds a replica is allowed to run.
     */
    @JvmName("aenlpmsxdmacmcnc")
    public suspend fun replicaTimeout(`value`: Output<Int>) {
        this.replicaTimeout = value
    }

    /**
     * @param value Cron formatted repeating trigger schedule ("* * * * *") for cronjobs. Properties completions and parallelism would be set to 1 by default
     */
    @JvmName("ohqyjkwlnvasktkx")
    public suspend
    fun scheduleTriggerConfig(`value`: Output<JobConfigurationScheduleTriggerConfigArgs>) {
        this.scheduleTriggerConfig = value
    }

    /**
     * @param value Collection of secrets used by a Container Apps Job
     */
    @JvmName("elttunbvchfriuwt")
    public suspend fun secrets(`value`: Output<List<SecretArgs>>) {
        this.secrets = value
    }

    @JvmName("ghorqsonooywukew")
    public suspend fun secrets(vararg values: Output<SecretArgs>) {
        this.secrets = Output.all(values.asList())
    }

    /**
     * @param values Collection of secrets used by a Container Apps Job
     */
    @JvmName("acfolxxncvqwxvbe")
    public suspend fun secrets(values: List<Output<SecretArgs>>) {
        this.secrets = Output.all(values)
    }

    /**
     * @param value Trigger type of the job
     */
    @JvmName("yldgihrscfmuvouc")
    public suspend fun triggerType(`value`: Output<Either<String, TriggerType>>) {
        this.triggerType = value
    }

    /**
     * @param value Trigger configuration of an event driven job.
     */
    @JvmName("osbpsonrluchhmet")
    public suspend fun eventTriggerConfig(`value`: JobConfigurationEventTriggerConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventTriggerConfig = mapped
    }

    /**
     * @param argument Trigger configuration of an event driven job.
     */
    @JvmName("gudknlvitlunvscl")
    public suspend
    fun eventTriggerConfig(argument: suspend JobConfigurationEventTriggerConfigArgsBuilder.() -> Unit) {
        val toBeMapped = JobConfigurationEventTriggerConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.eventTriggerConfig = mapped
    }

    /**
     * @param value Manual trigger configuration for a single execution job. Properties replicaCompletionCount and parallelism would be set to 1 by default
     */
    @JvmName("wljwiidnxfnrcdwu")
    public suspend fun manualTriggerConfig(`value`: JobConfigurationManualTriggerConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.manualTriggerConfig = mapped
    }

    /**
     * @param argument Manual trigger configuration for a single execution job. Properties replicaCompletionCount and parallelism would be set to 1 by default
     */
    @JvmName("cjyfaoatfljhydub")
    public suspend
    fun manualTriggerConfig(argument: suspend JobConfigurationManualTriggerConfigArgsBuilder.() -> Unit) {
        val toBeMapped = JobConfigurationManualTriggerConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.manualTriggerConfig = mapped
    }

    /**
     * @param value Collection of private container registry credentials used by a Container apps job
     */
    @JvmName("dkmcvcwfbgicuevd")
    public suspend fun registries(`value`: List<RegistryCredentialsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registries = mapped
    }

    /**
     * @param argument Collection of private container registry credentials used by a Container apps job
     */
    @JvmName("quhffumemcvtbsyc")
    public suspend fun registries(argument: List<suspend RegistryCredentialsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RegistryCredentialsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.registries = mapped
    }

    /**
     * @param argument Collection of private container registry credentials used by a Container apps job
     */
    @JvmName("ppfptwqenimipakq")
    public suspend fun registries(
        vararg
        argument: suspend RegistryCredentialsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RegistryCredentialsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.registries = mapped
    }

    /**
     * @param argument Collection of private container registry credentials used by a Container apps job
     */
    @JvmName("gqgtpepcorxttkxh")
    public suspend fun registries(argument: suspend RegistryCredentialsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RegistryCredentialsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.registries = mapped
    }

    /**
     * @param values Collection of private container registry credentials used by a Container apps job
     */
    @JvmName("wwfxbgeyuabkinof")
    public suspend fun registries(vararg values: RegistryCredentialsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.registries = mapped
    }

    /**
     * @param value Maximum number of retries before failing the job.
     */
    @JvmName("tumsgfyundwgitbl")
    public suspend fun replicaRetryLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicaRetryLimit = mapped
    }

    /**
     * @param value Maximum number of seconds a replica is allowed to run.
     */
    @JvmName("ceaigfejrlcaqwio")
    public suspend fun replicaTimeout(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.replicaTimeout = mapped
    }

    /**
     * @param value Cron formatted repeating trigger schedule ("* * * * *") for cronjobs. Properties completions and parallelism would be set to 1 by default
     */
    @JvmName("gjssyhwrghcwefdu")
    public suspend fun scheduleTriggerConfig(`value`: JobConfigurationScheduleTriggerConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleTriggerConfig = mapped
    }

    /**
     * @param argument Cron formatted repeating trigger schedule ("* * * * *") for cronjobs. Properties completions and parallelism would be set to 1 by default
     */
    @JvmName("rcwdxirqhtwlckew")
    public suspend
    fun scheduleTriggerConfig(argument: suspend JobConfigurationScheduleTriggerConfigArgsBuilder.() -> Unit) {
        val toBeMapped = JobConfigurationScheduleTriggerConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.scheduleTriggerConfig = mapped
    }

    /**
     * @param value Collection of secrets used by a Container Apps Job
     */
    @JvmName("gdahmbkxsjpvrbgn")
    public suspend fun secrets(`value`: List<SecretArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secrets = mapped
    }

    /**
     * @param argument Collection of secrets used by a Container Apps Job
     */
    @JvmName("esadorxchejbsrbh")
    public suspend fun secrets(argument: List<suspend SecretArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SecretArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.secrets = mapped
    }

    /**
     * @param argument Collection of secrets used by a Container Apps Job
     */
    @JvmName("lmtsjhmwmsbxwwws")
    public suspend fun secrets(vararg argument: suspend SecretArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SecretArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.secrets = mapped
    }

    /**
     * @param argument Collection of secrets used by a Container Apps Job
     */
    @JvmName("smhytjgbigndyedg")
    public suspend fun secrets(argument: suspend SecretArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SecretArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.secrets = mapped
    }

    /**
     * @param values Collection of secrets used by a Container Apps Job
     */
    @JvmName("jyueicjhclmnfodx")
    public suspend fun secrets(vararg values: SecretArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secrets = mapped
    }

    /**
     * @param value Trigger type of the job
     */
    @JvmName("fxxyrwvsvygcajjb")
    public suspend fun triggerType(`value`: Either<String, TriggerType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.triggerType = mapped
    }

    /**
     * @param value Trigger type of the job
     */
    @JvmName("jbprdowsbehacske")
    public fun triggerType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TriggerType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.triggerType = mapped
    }

    /**
     * @param value Trigger type of the job
     */
    @JvmName("tciivdnqojnuhdim")
    public fun triggerType(`value`: TriggerType) {
        val toBeMapped = Either.ofRight<String, TriggerType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.triggerType = mapped
    }

    internal fun build(): JobConfigurationArgs = JobConfigurationArgs(
        eventTriggerConfig = eventTriggerConfig,
        manualTriggerConfig = manualTriggerConfig,
        registries = registries,
        replicaRetryLimit = replicaRetryLimit,
        replicaTimeout = replicaTimeout ?: throw PulumiNullFieldException("replicaTimeout"),
        scheduleTriggerConfig = scheduleTriggerConfig,
        secrets = secrets,
        triggerType = triggerType ?: throw PulumiNullFieldException("triggerType"),
    )
}
